/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.cache;

import com.ohaotian.base.cache.CacheManager;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisManager
implements CacheManager {
    private String host = "127.0.0.1";
    private int port = 6379;
    private int expire = 0;
    private int timeout = 0;
    private String password = "";
    private JedisPool jedisPool = null;

    public void init() {
        if (this.jedisPool == null) {
            this.jedisPool = this.password != null && !"".equals(this.password) ? new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port, this.timeout, this.password) : (this.timeout != 0 ? new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port, this.timeout) : new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(byte[] key) {
        byte[] value = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            value = jedis.get(key);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] set(byte[] key, byte[] value) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.set(key, value);
            if (this.expire != 0) {
                jedis.expire(key, this.expire);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] set(byte[] key, byte[] value, int expire) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.set(key, value);
            if (expire != 0) {
                jedis.expire(key, expire);
            }
        }
        return value;
    }

    @Override
    public void del(byte[] key) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.del(key);
        }
    }

    @Override
    public void flushDB() {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.flushDB();
        }
    }

    @Override
    public Long dbSize() {
        Long dbSize = 0L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            dbSize = jedis.dbSize();
        }
        return dbSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> keys(String pattern) {
        Set keys = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            keys = jedis.keys(pattern.getBytes());
        }
        return keys;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueExpireTime(byte[] key, int expire) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (expire != 0) {
                jedis.expire(key, expire);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getExpireTimeByKey(byte[] key) {
        Long expireTime = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            expireTime = jedis.ttl(key);
        }
        return expireTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(byte[] key) {
        Long num = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            num = jedis.incr(key);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrExpireTime(byte[] key, int expire) {
        Long num = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            num = jedis.incr(key);
            jedis.expire(key, expire);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrBy(byte[] key, long conut) {
        Long num = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            num = jedis.incrBy(key, conut);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrExpireTimeBy(byte[] key, long conut, int expire) {
        Long num = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            num = jedis.incrBy(key, conut);
            jedis.expire(key, expire);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getIncr(byte[] key) {
        Long num = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            byte[] bnum = jedis.get(key);
            String numStr = bnum == null ? null : new String(bnum);
            num = numStr == null ? null : Long.valueOf(Long.parseLong(numStr));
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpush(String key, String ... bytes) {
        Long res = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            res = jedis.rpush(key, bytes);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lpop(String key) {
        String res = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            res = jedis.lpop(key);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long llen(String key) {
        Long res = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            res = jedis.llen(key);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setnx(byte[] key, byte[] value) {
        Long res = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            res = jedis.setnx(key, value);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        byte[] res = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            res = jedis.getSet(key, value);
        }
        return res;
    }
}

