/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

public class ConverterUtil {
    public static String camelCaseName(String underscoreName) {
        StringBuilder result = new StringBuilder();
        if (underscoreName != null && underscoreName.length() > 0) {
            boolean flag = false;
            for (int i = 0; i < underscoreName.length(); ++i) {
                char ch = underscoreName.charAt(i);
                if ("_".charAt(0) == ch) {
                    flag = true;
                    continue;
                }
                if (flag) {
                    result.append(Character.toUpperCase(ch));
                    flag = false;
                    continue;
                }
                result.append(Character.toLowerCase(ch));
            }
        }
        return result.toString();
    }

    public static String underscoreName(String camelCaseName) {
        StringBuilder result = new StringBuilder();
        int len = camelCaseName.length();
        if (camelCaseName != null && len > 0) {
            result.append(camelCaseName.substring(0, 1).toUpperCase());
            for (int i = 1; i < len; ++i) {
                char ch = camelCaseName.charAt(i);
                if (Character.isUpperCase(ch)) {
                    result.append("_");
                    result.append(ch);
                    continue;
                }
                result.append(Character.toUpperCase(ch));
            }
        }
        return result.toString();
    }

    public static Object mapToObject(Class clazz, Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        Field[] fields = clazz.getDeclaredFields();
        Object o = null;
        try {
            o = clazz.newInstance();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String fieldName = field.getName();
            String stringLetter = fieldName.substring(0, 1).toUpperCase();
            String setterName = "set" + stringLetter + fieldName.substring(1);
            Method setMethod = null;
            Class<?> fieldClass = field.getType();
            try {
                if (!ConverterUtil.isHaveSuchMethod(clazz, setterName)) continue;
                if (fieldClass == String.class) {
                    setMethod = clazz.getMethod(setterName, fieldClass);
                    if (null == map.get(ConverterUtil.underscoreName(fieldName)) || "".equals(map.get(ConverterUtil.underscoreName(fieldName)))) continue;
                    setMethod.invoke(o, String.valueOf(map.get(ConverterUtil.underscoreName(fieldName))));
                    continue;
                }
                if (fieldClass == Integer.class || fieldClass == Integer.TYPE) {
                    setMethod = clazz.getMethod(setterName, fieldClass);
                    if (null == map.get(ConverterUtil.underscoreName(fieldName)) || "".equals(map.get(ConverterUtil.underscoreName(fieldName)))) continue;
                    setMethod.invoke(o, Integer.parseInt(String.valueOf(map.get(ConverterUtil.underscoreName(fieldName)))));
                    continue;
                }
                if (fieldClass == Boolean.class || fieldClass == Boolean.TYPE) {
                    setMethod = clazz.getMethod(setterName, fieldClass);
                    if (null == map.get(ConverterUtil.underscoreName(fieldName)) || "".equals(map.get(ConverterUtil.underscoreName(fieldName)))) continue;
                    setMethod.invoke(o, Boolean.getBoolean(String.valueOf(map.get(ConverterUtil.underscoreName(fieldName)))));
                    continue;
                }
                if (fieldClass == Short.class || fieldClass == Short.TYPE) {
                    setMethod = clazz.getMethod(setterName, fieldClass);
                    if (null == map.get(ConverterUtil.underscoreName(fieldName)) || "".equals(map.get(ConverterUtil.underscoreName(fieldName)))) continue;
                    setMethod.invoke(o, Short.parseShort(String.valueOf(map.get(ConverterUtil.underscoreName(fieldName)))));
                    continue;
                }
                if (fieldClass == Long.class || fieldClass == Long.TYPE) {
                    setMethod = clazz.getMethod(setterName, fieldClass);
                    if (null == map.get(ConverterUtil.underscoreName(fieldName)) || "".equals(map.get(ConverterUtil.underscoreName(fieldName)))) continue;
                    setMethod.invoke(o, Long.parseLong(String.valueOf(map.get(ConverterUtil.underscoreName(fieldName)))));
                    continue;
                }
                if (fieldClass == Double.class || fieldClass == Double.TYPE) {
                    setMethod = clazz.getMethod(setterName, fieldClass);
                    if (null == map.get(ConverterUtil.underscoreName(fieldName)) || "".equals(map.get(ConverterUtil.underscoreName(fieldName)))) continue;
                    setMethod.invoke(o, Double.parseDouble(String.valueOf(map.get(ConverterUtil.underscoreName(fieldName)))));
                    continue;
                }
                if (fieldClass == Float.class || fieldClass == Float.TYPE) {
                    setMethod = clazz.getMethod(setterName, fieldClass);
                    if (null == map.get(ConverterUtil.underscoreName(fieldName)) || "".equals(map.get(ConverterUtil.underscoreName(fieldName)))) continue;
                    setMethod.invoke(o, Float.valueOf(Float.parseFloat(String.valueOf(map.get(ConverterUtil.underscoreName(fieldName))))));
                    continue;
                }
                if (fieldClass == BigInteger.class) {
                    setMethod = clazz.getMethod(setterName, fieldClass);
                    if (null == map.get(ConverterUtil.underscoreName(fieldName)) || "".equals(map.get(ConverterUtil.underscoreName(fieldName)))) continue;
                    setMethod.invoke(o, BigInteger.valueOf(Long.parseLong(String.valueOf(map.get(ConverterUtil.underscoreName(fieldName))))));
                    continue;
                }
                if (fieldClass == BigDecimal.class) {
                    setMethod = clazz.getMethod(setterName, fieldClass);
                    if (null == map.get(ConverterUtil.underscoreName(fieldName)) || "".equals(map.get(ConverterUtil.underscoreName(fieldName)))) continue;
                    setMethod.invoke(o, BigDecimal.valueOf(Long.parseLong(String.valueOf(map.get(ConverterUtil.underscoreName(fieldName))))));
                    continue;
                }
                if (fieldClass != Date.class) continue;
                setMethod = clazz.getMethod(setterName, fieldClass);
                if (null == map.get(ConverterUtil.underscoreName(fieldName)) || "".equals(map.get(ConverterUtil.underscoreName(fieldName)))) continue;
                DateTime date = ISODateTimeFormat.dateTimeParser().parseDateTime((String)map.get(ConverterUtil.underscoreName(fieldName)));
                setMethod.invoke(o, new Date(date.getMillis()));
                continue;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return o;
    }

    public static boolean isHaveSuchMethod(Class<?> clazz, String methodName) {
        Method[] methodArray = clazz.getMethods();
        boolean result = false;
        if (null != methodArray) {
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(methodName)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static void main(String[] args) {
        System.err.println(ConverterUtil.underscoreName("name_full"));
        System.err.println(ConverterUtil.camelCaseName("NAME_FILL"));
        System.err.println(ConverterUtil.camelCaseName("nameFill"));
        System.err.println(ConverterUtil.underscoreName("nameFill"));
    }
}

