/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.common.util;

import com.ohaotian.base.common.util.TopologyBO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUtils {
    private static Logger log = LoggerFactory.getLogger(DbUtils.class);
    private DataSource mysqlDataSource;
    private static int shardingTotalCount;
    private String showNodesSql;
    private static List<TopologyBO> topologys;

    public DataSource getMysqlDataSource() {
        return this.mysqlDataSource;
    }

    public void setMysqlDataSource(DataSource mysqlDataSource) {
        this.mysqlDataSource = mysqlDataSource;
    }

    public static int getShardingTotalCount() {
        return shardingTotalCount;
    }

    public void setShowNodesSql(String showNodesSql) {
        this.showNodesSql = showNodesSql;
    }

    public List<TopologyBO> getTopologys() {
        return topologys;
    }

    public static String getHitSql(int id) {
        TopologyBO bo = topologys.get(id);
        String hitSql = "/*TDDL:node='" + bo.getGroupName() + "'*/";
        return hitSql;
    }

    public void init() {
        try {
            List<Map<String, Object>> list = this.getQueryList(this.showNodesSql, null);
            topologys = new ArrayList<TopologyBO>(list.size());
            shardingTotalCount = list.size();
            for (Map<String, Object> map : list) {
                TopologyBO bo = new TopologyBO();
                bo.setGroupName(map.get("GROUP_NAME").toString());
                bo.setId(Integer.parseInt(map.get("ID").toString()));
                bo.setTableName(map.get("TABLE_NAME").toString());
                topologys.add(bo);
            }
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u83b7\u53d6\u5206\u5e93\u7684sql\u51fa\u9519\u4e86\uff01", (Throwable)e);
        }
    }

    public int execute(String sql, List<Object> paramList) throws Exception {
        int result;
        PreparedStatement pstmt;
        Connection conn;
        block6: {
            if (sql == null || sql.trim().equals("")) {
                // empty if block
            }
            conn = null;
            pstmt = null;
            result = 0;
            conn = this.getConnection();
            pstmt = DbUtils.getPreparedStatement(conn, sql);
            this.setPreparedStatementParam(pstmt, paramList);
            if (pstmt != null) break block6;
            int n = -1;
            this.closeStatement(pstmt);
            this.closeConn(conn);
            return n;
        }
        try {
            result = pstmt.executeUpdate();
            this.closeStatement(pstmt);
            this.closeConn(conn);
        }
        catch (Exception e) {
            try {
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                this.closeStatement(pstmt);
                this.closeConn(conn);
                throw throwable;
            }
        }
        return result;
    }

    public List<Map<String, Object>> getQueryList(String sql, List<Object> paramList) throws Exception {
        if (sql == null || sql.trim().equals("")) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        List<Map<String, Object>> queryList = null;
        try {
            conn = this.getConnection();
            pstmt = DbUtils.getPreparedStatement(conn, sql);
            this.setPreparedStatementParam(pstmt, paramList);
            if (pstmt == null) {
                List<Map<String, Object>> list = null;
                return list;
            }
            pstmt.setFetchSize(Integer.MIN_VALUE);
            rs = this.getResultSet(pstmt);
            queryList = this.getQueryList(rs);
            this.closeResultSet(rs);
        }
        catch (RuntimeException e) {
            System.out.println("parameter is valid!");
            throw new Exception(e);
        }
        finally {
            this.closeResultSet(rs);
            this.closeStatement(pstmt);
            this.closeConn(conn);
        }
        this.closeStatement(pstmt);
        this.closeConn(conn);
        return queryList;
    }

    public void setPreparedStatementParam(PreparedStatement pstmt, List<Object> paramList) throws Exception {
        if (pstmt == null || paramList == null || paramList.isEmpty()) {
            return;
        }
        DateFormat df = DateFormat.getDateTimeInstance();
        for (int i = 0; i < paramList.size(); ++i) {
            if (paramList.get(i) instanceof Integer) {
                int paramValue = (Integer)paramList.get(i);
                pstmt.setInt(i + 1, paramValue);
                continue;
            }
            if (paramList.get(i) instanceof Float) {
                float paramValue = ((Float)paramList.get(i)).floatValue();
                pstmt.setFloat(i + 1, paramValue);
                continue;
            }
            if (paramList.get(i) instanceof Double) {
                double paramValue = (Double)paramList.get(i);
                pstmt.setDouble(i + 1, paramValue);
                continue;
            }
            if (paramList.get(i) instanceof Date) {
                pstmt.setString(i + 1, df.format((Date)paramList.get(i)));
                continue;
            }
            if (paramList.get(i) instanceof Long) {
                long paramValue = (Long)paramList.get(i);
                pstmt.setLong(i + 1, paramValue);
                continue;
            }
            if (!(paramList.get(i) instanceof String)) continue;
            pstmt.setString(i + 1, (String)paramList.get(i));
        }
    }

    public Connection getConnection() throws Exception {
        return this.mysqlDataSource.getConnection();
    }

    public static PreparedStatement getPreparedStatement(Connection conn, String sql) throws Exception {
        if (conn == null || sql == null || sql.trim().equals("")) {
            return null;
        }
        PreparedStatement pstmt = conn.prepareStatement(sql.trim());
        return pstmt;
    }

    private ResultSet getResultSet(PreparedStatement pstmt) throws Exception {
        if (pstmt == null) {
            return null;
        }
        ResultSet rs = pstmt.executeQuery();
        return rs;
    }

    private List<Map<String, Object>> getQueryList(ResultSet rs) throws Exception {
        if (rs == null) {
            return null;
        }
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int columnCount = rsMetaData.getColumnCount();
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            for (int i = 0; i < columnCount; ++i) {
                dataMap.put(rsMetaData.getColumnName(i + 1), rs.getObject(i + 1));
            }
            dataList.add(dataMap);
        }
        return dataList;
    }

    public void closeConn(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void closeStatement(Statement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void closeResultSet(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

