/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.common.util;

import com.ohaotian.base.common.bo.RspInfoBO;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;

public class ExcelExport<T> {
    private String sheetTitle = "Sheet1";
    private String[] headers = new String[0];
    private List<T> datasets = new ArrayList<T>();
    private String dateFormat = "yyyy-MM-dd";
    private FileOutputStream fileout = null;

    public ExcelExport() {
    }

    public ExcelExport(List<T> datasets, FileOutputStream fileout) {
        this.datasets = datasets;
        this.fileout = fileout;
    }

    public ExcelExport(String sheetTitle, List<T> datasets, FileOutputStream fileout) {
        this(datasets, fileout);
        this.sheetTitle = sheetTitle;
    }

    public ExcelExport(String[] headers, List<T> datasets, FileOutputStream fileout) {
        this(datasets, fileout);
        this.headers = headers;
    }

    public ExcelExport(String sheetTitle, String[] headers, List<T> datasets, FileOutputStream fileout) {
        this(sheetTitle, datasets, fileout);
        this.headers = headers;
    }

    public ExcelExport(String sheetTitle, String[] headers, List<T> datasets, String dateFormat, FileOutputStream fileout) {
        this(sheetTitle, headers, datasets, fileout);
        this.dateFormat = dateFormat;
    }

    public ExcelExport(List<T> datasets) {
        this.datasets = datasets;
    }

    public ExcelExport(String[] headers, List<T> datasets) {
        this.headers = headers;
        this.datasets = datasets;
    }

    public RspInfoBO ExportExcel() throws Exception {
        RspInfoBO RspInfo = new RspInfoBO();
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(this.sheetTitle);
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setAlignment((short)2);
        titleStyle.setVerticalAlignment((short)1);
        HSSFFont titleFont = workbook.createFont();
        titleFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        titleFont.setFontHeightInPoints((short)12);
        titleStyle.setFont(titleFont);
        HSSFCellStyle bodyStyle = workbook.createCellStyle();
        bodyStyle.cloneStyleFrom(titleStyle);
        HSSFFont bodyFont = workbook.createFont();
        bodyFont.setFontName("\u5b8b\u4f53");
        bodyFont.setColor((short)8);
        bodyFont.setFontHeightInPoints((short)12);
        bodyStyle.setFont(bodyFont);
        int index = 0;
        HSSFRow row = null;
        if (this.headers.length > 0) {
            row = sheet.createRow(index++);
            row.setHeightInPoints(15.0f);
            for (int i = 0; i < this.headers.length; ++i) {
                HSSFCell cell = row.createCell(i);
                HSSFRichTextString text = new HSSFRichTextString(this.headers[i]);
                cell.setCellValue((RichTextString)text);
                cell.setCellStyle(titleStyle);
            }
        }
        Iterator<T> it = this.datasets.iterator();
        while (it.hasNext()) {
            row = sheet.createRow(index);
            row.setHeightInPoints(15.0f);
            T t = it.next();
            Field[] fields = t.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                HSSFCell cell = row.createCell(i);
                cell.setCellStyle(bodyStyle);
                Field field = fields[i];
                field.setAccessible(true);
                Object value = field.get(t);
                String textValue = null;
                if (value instanceof Date) {
                    Date date = (Date)value;
                    SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
                    textValue = sdf.format(date);
                } else {
                    textValue = value.toString();
                }
                if (textValue == null) continue;
                Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                Matcher matcher = p.matcher(textValue);
                if (matcher.matches()) {
                    cell.setCellValue(Double.parseDouble(textValue));
                    continue;
                }
                cell.setCellValue(textValue);
            }
            ++index;
        }
        workbook.write((OutputStream)this.fileout);
        this.fileout.flush();
        this.fileout.close();
        return RspInfo;
    }

    public RspInfoBO ExportExcelTOStream(OutputStream outputStream) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(this.sheetTitle);
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setAlignment((short)2);
        titleStyle.setVerticalAlignment((short)1);
        HSSFFont titleFont = workbook.createFont();
        titleFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        titleFont.setFontHeightInPoints((short)12);
        titleStyle.setFont(titleFont);
        HSSFCellStyle bodyStyle = workbook.createCellStyle();
        bodyStyle.cloneStyleFrom(titleStyle);
        HSSFFont bodyFont = workbook.createFont();
        bodyFont.setFontName("\u5b8b\u4f53");
        bodyFont.setColor((short)8);
        bodyFont.setFontHeightInPoints((short)12);
        bodyStyle.setFont(bodyFont);
        int index = 0;
        HSSFRow row = null;
        if (this.headers.length > 0) {
            row = sheet.createRow(index++);
            row.setHeightInPoints(15.0f);
            for (int i = 0; i < this.headers.length; ++i) {
                HSSFCell cell = row.createCell(i);
                HSSFRichTextString text = new HSSFRichTextString(this.headers[i]);
                cell.setCellValue((RichTextString)text);
                cell.setCellStyle(titleStyle);
            }
        }
        Iterator<T> it = this.datasets.iterator();
        while (it.hasNext()) {
            row = sheet.createRow(index);
            row.setHeightInPoints(15.0f);
            T t = it.next();
            Field[] fields = t.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                HSSFCell cell = row.createCell(i);
                cell.setCellStyle(bodyStyle);
                Field field = fields[i];
                field.setAccessible(true);
                Object value = field.get(t);
                String textValue = null;
                if (value instanceof Date) {
                    Date date = (Date)value;
                    SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
                    textValue = sdf.format(date);
                } else {
                    String string = textValue = value == null ? "" : value.toString();
                }
                if (textValue == null) continue;
                Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                Matcher matcher = p.matcher(textValue);
                if (matcher.matches()) {
                    cell.setCellValue(Double.parseDouble(textValue));
                    continue;
                }
                cell.setCellValue(textValue);
            }
            ++index;
        }
        workbook.write(outputStream);
        return new RspInfoBO();
    }
}

