/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class PropertiesFileLoader
extends PropertiesFactoryBean {
    Logger logger = LogManager.getLogger(PropertiesFileLoader.class);
    public static final String CONFIG_PATH_ARG = "config.path";
    public static final String OLD_CONFIG_PATH_ARG = "propertyFile";

    public PropertiesFileLoader(List<String> paths) {
        System.out.println("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
        ArrayList<String> newList = new ArrayList<String>();
        if (System.getProperty(CONFIG_PATH_ARG) != null) {
            paths.add("file:" + System.getProperty(CONFIG_PATH_ARG));
        }
        if (System.getProperty(OLD_CONFIG_PATH_ARG) != null) {
            paths.add("file:" + System.getProperty(OLD_CONFIG_PATH_ARG));
        }
        for (int i = 0; i < paths.size(); ++i) {
            String location = paths.get(i);
            if (location.startsWith("profile:")) {
                String userDir = ((Object)((Object)this)).getClass().getClassLoader().getResource("").toString();
                String addr = userDir + "../../../../../" + location.substring(8);
                this.dealPath(newList, addr.substring(5), addr);
                String addr2 = userDir + "../../../" + location.substring(8);
                this.dealPath(newList, addr2.substring(5), addr2);
                continue;
            }
            if (location.startsWith("classpath:")) {
                String classpath = ((Object)((Object)this)).getClass().getClassLoader().getResource("").getFile().toString();
                this.dealPath(newList, classpath + location.substring(10), location);
                continue;
            }
            if (location.startsWith("file:")) {
                this.dealPath(newList, location.substring(5), location);
                continue;
            }
            this.dealPath(newList, location, location);
        }
        if (newList.size() < 1) {
            this.logger.error("No valid configuration. Exit system !!!");
            System.exit(1);
        }
        Resource[] resources = new Resource[newList.size()];
        for (int i = 0; i < resources.length; ++i) {
            this.logger.info("Valid path: " + (String)newList.get(i));
            resources[i] = new DefaultResourceLoader().getResource((String)newList.get(i));
        }
        this.setLocations(resources);
    }

    private void dealPath(List<String> newList, String testPath, String location) {
        if (!new File(testPath).exists()) {
            this.logger.info("Invalid path:" + location);
        } else {
            newList.add(location);
        }
    }

    public Properties getProperties() {
        try {
            return this.getObject();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

