/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.CollectionUtils;

public class PropertiesBeanFactory
implements FactoryBean<Properties>,
InitializingBean {
    private static final PathMatchingResourcePatternResolver PMRPR = new PathMatchingResourcePatternResolver(PropertiesBeanFactory.class.getClassLoader());
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Properties mergedProp = new Properties();
    private List<String> locations;

    public Properties getObject() throws Exception {
        return this.mergedProp;
    }

    public Class<?> getObjectType() {
        return Properties.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public void afterPropertiesSet() throws Exception {
        ArrayList<Properties> propList = new ArrayList<Properties>();
        for (int i = 0; this.locations != null && i < this.locations.size(); ++i) {
            this.loadProps(propList, this.locations.get(i));
        }
        String propertyFile = System.getProperty("propertyFile");
        if (propertyFile != null || !"".equals(propertyFile)) {
            this.loadProps(propList, propertyFile);
        }
        for (Properties prop : propList) {
            CollectionUtils.mergePropertiesIntoMap((Properties)prop, (Map)this.mergedProp);
        }
    }

    private void loadProps(List<Properties> propList, String propertiesFile) throws Exception {
        Resource[] resources;
        String classpathPro = "classpath:";
        if (propertiesFile.startsWith(classpathPro)) {
            String formatedFilePath = propertiesFile.replace("/", File.separator).substring(classpathPro.length());
            File tmpFile = new File(PMRPR.getResource(classpathPro + "./").getFile().getCanonicalPath() + File.separator + formatedFilePath);
            formatedFilePath = "file:" + tmpFile.getCanonicalPath();
            this.logger.info("trans path[" + propertiesFile + "] to path[" + formatedFilePath + "].");
            propertiesFile = formatedFilePath;
        }
        if (!propertiesFile.startsWith("file:")) {
            propertiesFile = "file:" + propertiesFile;
        }
        for (Resource resource : resources = PMRPR.getResources(propertiesFile)) {
            if (!resource.exists()) {
                this.logger.info("can not load config file:[" + propertiesFile + "]. it is not exists.");
                continue;
            }
            this.logger.info("load config file:[" + propertiesFile + "]");
            propList.add(this.loadPropFromResource(resource, propertiesFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropFromResource(Resource resource, String propertiesFile) {
        Properties prop = new Properties();
        InputStream propInput = null;
        try {
            propInput = resource.getInputStream();
            prop.load(propInput);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "load prop config [" + propertiesFile + "] error:" + e.getMessage());
        }
        finally {
            if (propInput != null) {
                try {
                    propInput.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, "close prop config [" + propertiesFile + "] stream error:" + e.getMessage());
                }
            }
        }
        return prop;
    }
}

