package com.ohaotian.base.config;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/**
 * You can run load property configuration by external parameters.
 * e.g. set jvm parameters: -Dconfig.path=/User/hofoo/test.properties
 */
public class PropertiesFileLoader extends PropertiesFactoryBean {
    Logger logger = LoggerFactory.getLogger(PropertiesFileLoader.class);

    public static final String CONFIG_PATH_ARG = "config.path";
    public static final String OLD_CONFIG_PATH_ARG = "propertyFile";

    public PropertiesFileLoader(List<String> paths) {
        System.out.println("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
        List<String> newList = new ArrayList<String>();
        if (System.getProperty(CONFIG_PATH_ARG) != null) {
            paths.add("file:" + System.getProperty(CONFIG_PATH_ARG));
        }
        if (System.getProperty(OLD_CONFIG_PATH_ARG) != null) {
            paths.add("file:" + System.getProperty(OLD_CONFIG_PATH_ARG));
        }
        //get valid paths.
        for (int i = 0; i < paths.size(); i++) {
            String location = paths.get(i);
            if (location.startsWith("profile:")) {
                //拼装classloader路径，对应各中心配置文件
                // file:/E:/projectFile/workspace/hk/user/user-center/target/user-center-1.0-SNAPSHOT/WEB-INF/classes/
                String userDir = getClass().getClassLoader().getResource("").toString();
                String addr = userDir + "../../../../../" + location.substring(8);
                dealPath(newList, addr.substring(5), addr);
                String addr2 = userDir + "../../../" + location.substring(8);
                dealPath(newList, addr2.substring(5), addr2);
            } else if (location.startsWith("classpath:")) {
                String classpath = getClass().getClassLoader().getResource("").getFile().toString();
                dealPath(newList, classpath + location.substring(10), location);
            } else if (location.startsWith("file:")) {
                dealPath(newList, location.substring(5), location);
            } else {
                dealPath(newList, location, location);
            }
        }

        if (newList.size() < 1) {
            logger.error("No valid configuration. Exit system !!!");
            System.exit(1);
        }
        Resource[] resources = new Resource[newList.size()];
        for (int i = 0; i < resources.length; i++) {
            logger.info("Valid path: " + newList.get(i));
            resources[i] = new DefaultResourceLoader().getResource(newList.get(i));
        }
        setLocations(resources);
    }

    private void dealPath(List<String> newList, String testPath, String location) {
        if (!new File(testPath).exists()) {
            logger.info("Invalid path:" + location);
        } else {
            newList.add(location);
        }
    }

    public Properties getProperties() {
        try {
            return getObject();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

