/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.es.annotation;

import com.ohaotian.base.es.annotation.DaoInjector;
import com.ohaotian.base.es.elasticsearch.ElasticSearchDAO;
import com.ohaotian.base.es.opensearch.OpenSearchDAO;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class DaoAdapterFactory
implements MethodInterceptor {
    private final Logger logger = LogManager.getLogger(DaoAdapterFactory.class);
    private ElasticSearchDAO esDao;
    private OpenSearchDAO osDao;
    private DaoInjector.DBType dbType;

    public Object generate(Class interfaceClass, DaoInjector.DBType dbType) {
        this.logger.debug("\u751f\u6210\u63a5\u53e3\u7684\u52a8\u6001\u4ee3\u7406, \u63a5\u53e3\u540d\uff1a{}\uff0c\u8981\u6c42\u4ee3\u7406\u7684\u6570\u636e\u5e93\u7c7b\u578b\u4e3a\uff1a{}", (Object)interfaceClass.getName(), (Object)dbType.name());
        this.dbType = dbType;
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(interfaceClass);
        enhancer.setCallback((Callback)this);
        return enhancer.create();
    }

    public Object intercept(Object o, Method method, Object[] objects, MethodProxy proxy) throws Throwable {
        if (DaoInjector.DBType.ElasticSearch.equals((Object)this.dbType)) {
            return method.invoke((Object)this.esDao, objects);
        }
        if (DaoInjector.DBType.OpenSearch.equals((Object)this.dbType)) {
            return method.invoke((Object)this.osDao, objects);
        }
        throw new RuntimeException();
    }

    public void setEsDao(ElasticSearchDAO esDao) {
        this.esDao = esDao;
    }

    public void setOsDao(OpenSearchDAO osDao) {
        this.osDao = osDao;
    }
}

