/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.es.annotation;

import com.ohaotian.base.es.annotation.DaoAdapterFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.stereotype.Component;

@Component
public class DaoAutowiredBeanContainer {
    private List<DaoAutowiredBean> beans;
    private final ConcurrentMap<String, DaoAdapterFactory> factoryMap = new ConcurrentHashMap<String, DaoAdapterFactory>();

    public DaoAutowiredBeanContainer() {
        this.beans = new ArrayList<DaoAutowiredBean>();
    }

    public void addDaoAutowiredBean(DaoAutowiredBean bean) {
        this.beans.add(bean);
    }

    public List<DaoAutowiredBean> getBeans() {
        return this.beans;
    }

    public DaoAdapterFactory getOrCreate(String interFaceName) {
        if (!this.factoryMap.containsKey(interFaceName)) {
            DaoAdapterFactory factory = new DaoAdapterFactory();
            this.factoryMap.put(interFaceName, factory);
        }
        return (DaoAdapterFactory)this.factoryMap.get(interFaceName);
    }

    public ConcurrentMap<String, DaoAdapterFactory> getFactoryMap() {
        return this.factoryMap;
    }

    public static class DaoAutowiredBean {
        private final Object bean;
        private final Field daoField;

        public DaoAutowiredBean(Object bean, Field daoField) {
            this.bean = bean;
            this.daoField = daoField;
        }

        public Object getBean() {
            return this.bean;
        }

        public Field getDaoField() {
            return this.daoField;
        }
    }
}

