/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.es.builder.create;

import com.ohaotian.base.es.builder.Builder;

public class SettingsBuilder
implements Builder<Setting> {
    private int numberOfShards;
    private int numberOfReplicas;
    private int refreshInterval;

    private SettingsBuilder() {
    }

    public static SettingsBuilder newBuilder() {
        return new SettingsBuilder();
    }

    public SettingsBuilder numberOfShards(int num) {
        this.numberOfShards = num;
        return this;
    }

    public SettingsBuilder numberOfReplicas(int num) {
        this.numberOfReplicas = num;
        return this;
    }

    public SettingsBuilder refreshInterval(int interval) {
        this.refreshInterval = interval;
        return this;
    }

    @Override
    public Setting build() {
        return new Setting(this.numberOfShards, this.numberOfReplicas, this.refreshInterval);
    }

    public class Setting {
        private final int numberOfShards;
        private final int numberOfReplicas;
        private final int refreshInterval;

        public Setting(int numberOfShards, int numberOfReplicas, int refreshInterval) {
            this.numberOfShards = numberOfShards;
            this.numberOfReplicas = numberOfReplicas;
            this.refreshInterval = refreshInterval;
        }

        public int getNumberOfShards() {
            return this.numberOfShards;
        }

        public int getNumberOfReplicas() {
            return this.numberOfReplicas;
        }

        public int getRefreshInterval() {
            return this.refreshInterval;
        }
    }
}

