/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.es.builder.search;

import com.ohaotian.base.es.builder.Builder;
import com.ohaotian.base.es.builder.search.AggregateBuilder;
import com.ohaotian.base.es.builder.search.FetchBuilder;
import com.ohaotian.base.es.builder.search.FilterBuilder;
import com.ohaotian.base.es.builder.search.QueryBuilder;
import com.ohaotian.base.es.builder.search.RankBuilder;
import com.ohaotian.base.es.builder.search.SearchRequestBuilder;
import com.ohaotian.base.es.builder.search.SortBuilder;
import com.ohaotian.base.es.builder.search.result.Result;
import org.springframework.util.StringUtils;

public class SearchBuilder
implements Builder<Result> {
    private String indexName;
    private int from;
    private int size;
    private QueryBuilder queryBuilder;
    private FilterBuilder filterBuilder;
    private FetchBuilder fetchBuilder;
    private SortBuilder sortBuilder;
    private AggregateBuilder aggregateBuilder;
    private final SearchRequestBuilder searchRequestBuilder;
    private RankBuilder rankBuilder;
    private String kvpairs;

    private SearchBuilder(SearchRequestBuilder searchRequestBuilder) {
        this.searchRequestBuilder = searchRequestBuilder;
    }

    public static SearchBuilder newBuilder(SearchRequestBuilder searchRequestBuilder) {
        return new SearchBuilder(searchRequestBuilder);
    }

    public SearchBuilder setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public SearchBuilder setFrom(int from) {
        this.from = from;
        return this;
    }

    public SearchBuilder setSize(int size) {
        this.size = size;
        return this;
    }

    public QueryBuilder queryBuilder() {
        if (this.queryBuilder == null) {
            this.queryBuilder = QueryBuilder.newBuilder();
        }
        return this.queryBuilder;
    }

    public void setQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public FilterBuilder filterBuilder() {
        if (this.filterBuilder == null) {
            this.filterBuilder = FilterBuilder.newBuilder();
        }
        return this.filterBuilder;
    }

    public void setFilterBuilder(FilterBuilder filterBuilder) {
        this.filterBuilder = filterBuilder;
    }

    public FetchBuilder fetchBuilder() {
        if (this.fetchBuilder == null) {
            this.fetchBuilder = FetchBuilder.newBuilder();
        }
        return this.fetchBuilder;
    }

    public void setSortBuilder(SortBuilder sortBuilder) {
        this.sortBuilder = sortBuilder;
    }

    public SortBuilder sortBuilder() {
        if (this.sortBuilder == null) {
            this.sortBuilder = SortBuilder.newBuilder();
        }
        return this.sortBuilder;
    }

    public void setFetchBuilder(FetchBuilder fetchBuilder) {
        this.fetchBuilder = fetchBuilder;
    }

    public AggregateBuilder aggregateBuilder() {
        if (this.aggregateBuilder == null) {
            this.aggregateBuilder = AggregateBuilder.newBuilder();
        }
        return this.aggregateBuilder;
    }

    public void setAggregateBuilder(AggregateBuilder aggregateBuilder) {
        this.aggregateBuilder = aggregateBuilder;
    }

    public void setRankBuilder(RankBuilder rankBuilder) {
        this.rankBuilder = rankBuilder;
    }

    public RankBuilder rankBuilder() {
        if (this.rankBuilder == null) {
            this.rankBuilder = RankBuilder.newRankBuilder();
        }
        return this.rankBuilder;
    }

    @Override
    public Result build() {
        if (StringUtils.isEmpty((Object)this.indexName)) {
            throw new RuntimeException("\u9700\u8981\u8bbe\u7f6eindex name\uff0c\u901a\u8fc7SearchBuilder.setIndexName\u65b9\u6cd5\u8bbe\u7f6e");
        }
        Result result = this.searchRequestBuilder.build(this.indexName, this.from, this.size, this.queryBuilder, this.filterBuilder, this.fetchBuilder, this.sortBuilder, this.aggregateBuilder, this.rankBuilder, this.kvpairs);
        return result;
    }

    public void setKvpairs(String kvpairs) {
        this.kvpairs = kvpairs;
    }
}

