/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.es.elasticsearch;

import com.ohaotian.base.es.annotation.DaoInjector;
import com.ohaotian.base.es.builder.batch.BatchInsertRequestBuilderAdapter;
import com.ohaotian.base.es.builder.delete.DeleteRequestBuilderAdapter;
import com.ohaotian.base.es.builder.insert.InsertRequestBuilderAdapter;
import com.ohaotian.base.es.builder.search.SearchRequestBuilderAdapter;
import com.ohaotian.base.es.core.ClientException;
import com.ohaotian.base.es.core.Installer;
import com.ohaotian.base.es.elasticsearch.ElasticSearchClient;
import com.ohaotian.base.es.elasticsearch.ElasticSearchConfigCheck;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ElasticSearchInstaller
implements Installer {
    @Autowired
    private ElasticSearchConfigCheck configCheck;
    @Autowired
    private ElasticSearchClient client;
    @Autowired
    private DaoInjector daoInjector;
    @Autowired
    private InsertRequestBuilderAdapter insertRequestBuilderAdapter;
    @Autowired
    private BatchInsertRequestBuilderAdapter batchInsertRequestBuilderAdapter;
    @Autowired
    private DeleteRequestBuilderAdapter deleteRequestBuilderAdapter;
    @Autowired
    private SearchRequestBuilderAdapter searchRequestBuilderAdapter;

    @Override
    public boolean preInstall() {
        return this.configCheck.check();
    }

    @Override
    public void install() throws ClientException {
        this.client.initialize();
        this.daoInjector.inject(DaoInjector.DBType.ElasticSearch);
        this.insertRequestBuilderAdapter.setDBType(DaoInjector.DBType.ElasticSearch);
        this.batchInsertRequestBuilderAdapter.setDBType(DaoInjector.DBType.ElasticSearch);
        this.deleteRequestBuilderAdapter.setDBType(DaoInjector.DBType.ElasticSearch);
        this.searchRequestBuilderAdapter.setDBType(DaoInjector.DBType.ElasticSearch);
    }
}

