/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.es.elasticsearch.builder.create;

import com.ohaotian.base.es.builder.create.ColumnsBuilder;
import com.ohaotian.base.es.builder.create.CreateRequestBuilder;
import com.ohaotian.base.es.builder.create.SettingsBuilder;
import com.ohaotian.base.es.builder.schema.DataType;
import com.ohaotian.base.es.elasticsearch.ElasticSearchClient;
import java.io.IOException;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EsCreateRequestBuilder
implements CreateRequestBuilder {
    private final Logger logger = LogManager.getLogger(EsCreateRequestBuilder.class);
    @Autowired
    private ElasticSearchClient client;

    @Override
    public String build(String indexName, SettingsBuilder settingsBuilder, ColumnsBuilder columnsBuilder) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.client.createIndexRequestBuilder();
        createIndexRequestBuilder.setIndex(indexName);
        try {
            createIndexRequestBuilder.setSettings(this.createSettingBuilder(settingsBuilder));
            createIndexRequestBuilder.addMapping("default", this.createMappingBuilder(columnsBuilder));
            CreateIndexResponse response = (CreateIndexResponse)createIndexRequestBuilder.get();
            return response.toString();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private XContentBuilder createSettingBuilder(SettingsBuilder settingsBuilder) throws IOException {
        SettingsBuilder.Setting setting = settingsBuilder.build();
        return XContentFactory.jsonBuilder().startObject().field("index.number_of_shards", setting.getNumberOfShards()).field("index.number_of_replicas", setting.getNumberOfReplicas()).field("index.refresh_interval", String.valueOf(setting.getRefreshInterval()) + "s").endObject();
    }

    private XContentBuilder createMappingBuilder(ColumnsBuilder columnsBuilder) throws IOException {
        XContentBuilder mappingBuilder = XContentFactory.jsonBuilder().startObject().startObject("properties");
        Object columns = columnsBuilder.build();
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            ColumnsBuilder.Column column = (ColumnsBuilder.Column)iterator.next();
            if (column.getDataType().equals((Object)DataType.Nested)) {
                mappingBuilder.startObject(column.getName()).field("type", column.getDataType().name().toLowerCase()).startObject("properties").startObject("nested_id").field("type", "string".toLowerCase()).endObject().endObject().endObject();
                continue;
            }
            if (column.getDataType().equals((Object)DataType.Text)) {
                mappingBuilder.startObject(column.getName()).field("type", "string").endObject();
                continue;
            }
            mappingBuilder.startObject(column.getName()).field("type", column.getDataType().name().toLowerCase()).endObject();
        }
        mappingBuilder.endObject().endObject();
        this.logger.debug("create elasticsearch index: {}", (Object)mappingBuilder.string());
        return mappingBuilder;
    }
}

