/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.es.elasticsearch.builder.insert;

import com.ohaotian.base.es.builder.insert.ColumnValueBuilder;
import com.ohaotian.base.es.builder.insert.InsertBuilderItem;
import com.ohaotian.base.es.builder.insert.InsertRequestBuilder;
import com.ohaotian.base.es.builder.schema.DataType;
import com.ohaotian.base.es.builder.schema.Field;
import com.ohaotian.base.es.builder.schema.Nested;
import com.ohaotian.base.es.elasticsearch.ElasticSearchClient;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EsInsertRequestBuilder
implements InsertRequestBuilder<EsInsertBuilderItem> {
    private final Logger logger = LogManager.getLogger(EsInsertRequestBuilder.class);
    @Autowired
    private ElasticSearchClient client;

    @Override
    public EsInsertBuilderItem build(String tableName, String id, ColumnValueBuilder columnValueBuilder) {
        IndexRequestBuilder indexRequestBuilder = this.client.indexRequestBuilder();
        indexRequestBuilder.setIndex(tableName);
        indexRequestBuilder.setType("default");
        indexRequestBuilder.setId(id);
        indexRequestBuilder.setOpType(IndexRequest.OpType.INDEX);
        LinkedHashMap<String, Object> source = new LinkedHashMap<String, Object>();
        Object fields = columnValueBuilder.build();
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (DataType.Double.equals((Object)field.getDateType()) || DataType.Integer.equals((Object)field.getDateType()) || DataType.Long.equals((Object)field.getDateType())) {
                source.put(field.getName(), field.getValue());
                continue;
            }
            if (DataType.Text.equals((Object)field.getDateType())) {
                source.put(field.getName(), field.getValue());
                continue;
            }
            if (!DataType.Nested.equals((Object)field.getDateType())) continue;
            Nested nested = (Nested)field.getValue();
            LinkedList nestedList = new LinkedList();
            for (String nestedRow : nested.getRows()) {
                LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
                valueMap.put("nested_id", nestedRow);
                nestedList.add(valueMap);
            }
            source.put(field.getName(), nestedList);
        }
        indexRequestBuilder.setSource(source);
        this.logger.debug("update source: {}", source);
        return new EsInsertBuilderItem(indexRequestBuilder);
    }

    public class EsInsertBuilderItem
    implements InsertBuilderItem {
        private final IndexRequestBuilder indexRequestBuilder;

        public EsInsertBuilderItem(IndexRequestBuilder indexRequestBuilder) {
            this.indexRequestBuilder = indexRequestBuilder;
        }

        @Override
        public String get() {
            return String.valueOf(((IndexResponse)this.indexRequestBuilder.get()).isCreated());
        }
    }
}

