/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.es.elasticsearch.builder.search;

import com.ohaotian.base.es.builder.search.filter.BooleanFilterCondition;
import com.ohaotian.base.es.builder.search.filter.FilterCondition;
import com.ohaotian.base.es.builder.search.filter.MatchFilterCondition;
import com.ohaotian.base.es.builder.search.filter.RangeFilterCondition;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;

public enum ElasticSearchFilterBuilder {
    INSTANCE;


    public QueryBuilder build(FilterCondition condition) {
        if (condition instanceof MatchFilterCondition) {
            MatchFilterCondition matchCondition = (MatchFilterCondition)condition;
            return new MatchQueryBuilder(matchCondition.getColumnName(), matchCondition.getValue());
        }
        if (condition instanceof BooleanFilterCondition) {
            BooleanFilterCondition booleanCondition = (BooleanFilterCondition)condition;
            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            for (FilterCondition filterCondition : booleanCondition.getMust()) {
                boolQueryBuilder.must(this.build(filterCondition));
            }
            for (FilterCondition filterCondition : booleanCondition.getShould()) {
                boolQueryBuilder.should(this.build(filterCondition));
            }
            return boolQueryBuilder;
        }
        if (condition instanceof RangeFilterCondition) {
            RangeFilterCondition rangeCondition = (RangeFilterCondition)condition;
            RangeQueryBuilder rangeQueryBuilder = new RangeQueryBuilder(rangeCondition.getColumnName());
            if (rangeCondition.getOperator().equals((Object)RangeFilterCondition.Operator.GT)) {
                rangeQueryBuilder.gt(rangeCondition.getValue());
            } else if (rangeCondition.getOperator().equals((Object)RangeFilterCondition.Operator.GTE)) {
                rangeQueryBuilder.gte(rangeCondition.getValue());
            } else if (rangeCondition.getOperator().equals((Object)RangeFilterCondition.Operator.LT)) {
                rangeQueryBuilder.lt(rangeCondition.getValue());
            } else if (rangeCondition.getOperator().equals((Object)RangeFilterCondition.Operator.LTE)) {
                rangeQueryBuilder.lte(rangeCondition.getValue());
            }
            return rangeQueryBuilder;
        }
        throw new RuntimeException("\u7406\u8bba\u4e0a\u4e0d\u5e94\u8be5\u554a");
    }
}

