/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.es.elasticsearch.builder.search;

import com.ohaotian.base.es.builder.search.query.BooleanQueryCondition;
import com.ohaotian.base.es.builder.search.query.MatchQueryCondition;
import com.ohaotian.base.es.builder.search.query.QueryCondition;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public enum ElasticSearchQueryBuilder {
    INSTANCE;


    public QueryBuilder build(QueryCondition condition) {
        if (condition instanceof MatchQueryCondition) {
            MatchQueryCondition matchCondition = (MatchQueryCondition)condition;
            return new MatchQueryBuilder(matchCondition.getColumnName(), (Object)matchCondition.getValue());
        }
        if (condition instanceof BooleanQueryCondition) {
            BooleanQueryCondition booleanCondition = (BooleanQueryCondition)condition;
            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            for (QueryCondition queryCondition : booleanCondition.getMust()) {
                boolQueryBuilder.must(this.build(queryCondition));
            }
            for (QueryCondition queryCondition : booleanCondition.getShould()) {
                boolQueryBuilder.should(this.build(queryCondition));
            }
            return boolQueryBuilder;
        }
        throw new RuntimeException("\u7406\u8bba\u4e0a\u4e0d\u5e94\u8be5\u554a");
    }
}

