/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.es.opensearch.builder.delete;

import com.aliyun.opensearch.DocumentClient;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchResult;
import com.aliyun.opensearch.sdk.generated.document.Command;
import com.ohaotian.base.es.builder.delete.DeleteBuilderItem;
import com.ohaotian.base.es.builder.delete.DeleteRequestBuilder;
import com.ohaotian.base.es.builder.insert.ColumnValueBuilder;
import com.ohaotian.base.es.builder.schema.DataType;
import com.ohaotian.base.es.builder.schema.Field;
import com.ohaotian.base.es.builder.schema.Nested;
import com.ohaotian.base.es.opensearch.OpenSearchClient;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OsDeleteRequestBuilder
implements DeleteRequestBuilder<OsDeleteBuilderItem> {
    private final Logger logger = LogManager.getLogger(OsDeleteRequestBuilder.class);
    @Autowired
    private OpenSearchClient client;

    @Override
    public OsDeleteBuilderItem build(String tableName, String id, ColumnValueBuilder columnValueBuilder) {
        JSONArray rows = new JSONArray();
        JSONObject row = new JSONObject();
        row.put("cmd", (Object)Command.DELETE.toString());
        rows.put((Object)row);
        JSONObject doc = new JSONObject();
        row.put("fields", (Object)doc);
        Object fields = columnValueBuilder.build();
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (DataType.Double.equals((Object)field.getDateType()) || DataType.Integer.equals((Object)field.getDateType()) || DataType.Long.equals((Object)field.getDateType())) {
                doc.put(field.getName(), field.getValue());
                continue;
            }
            if (DataType.Text.equals((Object)field.getDateType())) {
                doc.put(field.getName(), field.getValue());
                continue;
            }
            if (DataType.Nested.equals((Object)field.getDateType())) {
                Nested nested = (Nested)field.getValue();
                JSONArray nestedArray = new JSONArray();
                for (String nestedRow : nested.getRows()) {
                    nestedArray.put((Object)nestedRow);
                }
                doc.put(field.getName(), (Object)nestedArray);
                continue;
            }
            if (!DataType.List.equals((Object)field.getDateType())) continue;
            List values = (List)field.getValue();
            JSONArray rows1 = new JSONArray();
            for (String s : values) {
                JSONObject doc1 = new JSONObject();
                JSONObject row1 = new JSONObject();
                row1.put("cmd", (Object)Command.DELETE.toString());
                row1.put("fields", (Object)doc1);
                rows1.put((Object)row1);
                doc1.put(field.getName(), (Object)s);
            }
            rows = rows1;
        }
        return new OsDeleteBuilderItem(tableName, rows, this.client);
    }

    public class OsDeleteBuilderItem
    implements DeleteBuilderItem {
        private final String tableName;
        private final JSONArray rows;
        private final OpenSearchClient client;

        public OsDeleteBuilderItem(String tableName, JSONArray rows, OpenSearchClient client) {
            this.tableName = tableName;
            this.rows = rows;
            this.client = client;
        }

        @Override
        public String get() {
            try {
                DocumentClient documentClient = this.client.createDocumentClient();
                OpenSearchResult result = documentClient.push(this.rows.toString(), this.tableName, this.tableName);
                return result.getResult();
            }
            catch (OpenSearchClientException | OpenSearchException e) {
                OsDeleteRequestBuilder.this.logger.error(e.getMessage(), e);
                return null;
            }
        }

        public String getTableName() {
            return this.tableName;
        }

        public JSONArray getRows() {
            return this.rows;
        }
    }
}

