/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.es.opensearch.builder.insert;

import com.aliyun.opensearch.DocumentClient;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchResult;
import com.aliyun.opensearch.sdk.generated.document.Command;
import com.ohaotian.base.es.builder.insert.ColumnValueBuilder;
import com.ohaotian.base.es.builder.insert.InsertBuilderItem;
import com.ohaotian.base.es.builder.insert.InsertRequestBuilder;
import com.ohaotian.base.es.builder.schema.DataType;
import com.ohaotian.base.es.builder.schema.Field;
import com.ohaotian.base.es.builder.schema.Nested;
import com.ohaotian.base.es.opensearch.OpenSearchClient;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OsInsertRequestBuilder
implements InsertRequestBuilder<OsInsertBuilderItem> {
    private final Logger logger = LogManager.getLogger(OsInsertRequestBuilder.class);
    @Autowired
    private OpenSearchClient client;

    @Override
    public OsInsertBuilderItem build(String tableName, String id, ColumnValueBuilder columnValueBuilder) {
        JSONArray rows = new JSONArray();
        JSONObject row = new JSONObject();
        row.put("cmd", (Object)Command.ADD.toString());
        rows.put((Object)row);
        JSONObject doc = new JSONObject();
        row.put("fields", (Object)doc);
        Object fields = columnValueBuilder.build();
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (DataType.Double.equals((Object)field.getDateType()) || DataType.Integer.equals((Object)field.getDateType()) || DataType.Long.equals((Object)field.getDateType())) {
                doc.put(field.getName(), field.getValue());
                continue;
            }
            if (DataType.Text.equals((Object)field.getDateType())) {
                doc.put(field.getName(), field.getValue());
                continue;
            }
            if (!DataType.Nested.equals((Object)field.getDateType())) continue;
            Nested nested = (Nested)field.getValue();
            JSONArray nestedArray = new JSONArray();
            for (String nestedRow : nested.getRows()) {
                nestedArray.put((Object)nestedRow);
            }
            doc.put(field.getName(), (Object)nestedArray);
        }
        return new OsInsertBuilderItem(tableName, rows, this.client);
    }

    public class OsInsertBuilderItem
    implements InsertBuilderItem {
        private final String tableName;
        private final JSONArray rows;
        private final OpenSearchClient client;

        public OsInsertBuilderItem(String tableName, JSONArray rows, OpenSearchClient client) {
            this.tableName = tableName;
            this.rows = rows;
            this.client = client;
        }

        @Override
        public String get() {
            try {
                DocumentClient documentClient = this.client.createDocumentClient();
                OpenSearchResult result = documentClient.push(this.rows.toString(), this.tableName, this.tableName);
                return result.getResult();
            }
            catch (OpenSearchClientException | OpenSearchException e) {
                OsInsertRequestBuilder.this.logger.error(e.getMessage(), e);
                return null;
            }
        }

        public String getTableName() {
            return this.tableName;
        }

        public JSONArray getRows() {
            return this.rows;
        }
    }
}

