/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.es.opensearch.builder.search;

import com.ohaotian.base.es.builder.search.query.BooleanQueryCondition;
import com.ohaotian.base.es.builder.search.query.MatchQueryCondition;
import com.ohaotian.base.es.builder.search.query.QueryCondition;

public enum OpenSearchQueryBuilder {
    INSTANCE;


    public String build(QueryCondition condition) {
        if (condition instanceof MatchQueryCondition) {
            MatchQueryCondition matchCondition = (MatchQueryCondition)condition;
            return matchCondition.getColumnName() + ":" + matchCondition.getValue();
        }
        if (condition instanceof BooleanQueryCondition) {
            BooleanQueryCondition booleanCondition = (BooleanQueryCondition)condition;
            StringBuilder boolConditionStr = new StringBuilder();
            boolConditionStr.append("(");
            if (booleanCondition.getMust().size() > 0) {
                boolConditionStr.append("(");
                boolean firstMust = true;
                for (QueryCondition queryCondition : booleanCondition.getMust()) {
                    if (!firstMust) {
                        boolConditionStr.append(" AND ");
                    }
                    boolConditionStr.append(this.build(queryCondition));
                    firstMust = false;
                }
                boolConditionStr.append(")");
            }
            if (booleanCondition.getShould().size() > 0) {
                if (booleanCondition.getMust().size() > 0) {
                    boolConditionStr.append(" OR ");
                }
                boolConditionStr.append("(");
                boolean firstShould = true;
                for (QueryCondition queryCondition : booleanCondition.getShould()) {
                    if (!firstShould) {
                        boolConditionStr.append(" OR ");
                    }
                    boolConditionStr.append(this.build(queryCondition));
                    firstShould = false;
                }
                boolConditionStr.append(")");
            }
            boolConditionStr.append(")");
            return boolConditionStr.toString();
        }
        throw new RuntimeException("\u7406\u8bba\u4e0a\u4e0d\u5e94\u8be5\u554a");
    }
}

