/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.es.opensearch.builder.search;

import com.aliyun.opensearch.SearcherClient;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.collect.Lists;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONObject;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.aliyun.opensearch.sdk.generated.search.Aggregate;
import com.aliyun.opensearch.sdk.generated.search.Config;
import com.aliyun.opensearch.sdk.generated.search.Order;
import com.aliyun.opensearch.sdk.generated.search.Rank;
import com.aliyun.opensearch.sdk.generated.search.SearchFormat;
import com.aliyun.opensearch.sdk.generated.search.SearchParams;
import com.aliyun.opensearch.sdk.generated.search.Sort;
import com.aliyun.opensearch.sdk.generated.search.SortField;
import com.aliyun.opensearch.sdk.generated.search.general.SearchResult;
import com.aliyun.opensearch.search.SearchResultDebug;
import com.ohaotian.base.es.builder.search.AggregateBuilder;
import com.ohaotian.base.es.builder.search.FetchBuilder;
import com.ohaotian.base.es.builder.search.FilterBuilder;
import com.ohaotian.base.es.builder.search.QueryBuilder;
import com.ohaotian.base.es.builder.search.RankBuilder;
import com.ohaotian.base.es.builder.search.SearchRequestBuilder;
import com.ohaotian.base.es.builder.search.SortBuilder;
import com.ohaotian.base.es.builder.search.filter.FilterCondition;
import com.ohaotian.base.es.builder.search.result.Result;
import com.ohaotian.base.es.builder.search.sort.SearchSortMode;
import com.ohaotian.base.es.builder.search.sort.SortColumn;
import com.ohaotian.base.es.opensearch.OpenSearchClient;
import com.ohaotian.base.es.opensearch.builder.search.OpenSearchFilterBuilder;
import com.ohaotian.base.es.opensearch.builder.search.OpenSearchQueryBuilder;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OsSearchRequestBuilder
implements SearchRequestBuilder {
    private final Logger logger = LogManager.getLogger(OsSearchRequestBuilder.class);
    @Autowired
    private OpenSearchClient client;

    @Override
    public Result build(String indexName, int from, int size, QueryBuilder queryBuilder, FilterBuilder filterBuilder, FetchBuilder fetchBuilder, SortBuilder sortBuilder, AggregateBuilder aggregateBuilder, RankBuilder rankBuilder, String kvpairs) {
        Iterator iterator;
        SearcherClient searchClient = this.client.createSearchClient();
        Config config = new Config((List)Lists.newArrayList((Object[])new String[]{indexName}));
        config.setStart(from);
        config.setKvpairs(kvpairs);
        if (size > 0) {
            config.setHits(size);
        }
        config.setSearchFormat(SearchFormat.JSON);
        if (fetchBuilder != null) {
            config.setFetchFields((List)fetchBuilder.build());
        }
        SearchParams searchParams = new SearchParams(config);
        if (queryBuilder != null) {
            searchParams.setQuery(OpenSearchQueryBuilder.INSTANCE.build(queryBuilder.build()));
        }
        if (filterBuilder != null) {
            searchParams.setFilter(OpenSearchFilterBuilder.INSTANCE.build(filterBuilder.build()));
        }
        if (sortBuilder != null) {
            Sort sorter = new Sort();
            iterator = sortBuilder.build().iterator();
            while (iterator.hasNext()) {
                SortColumn column = (SortColumn)iterator.next();
                if (SearchSortMode.ASC.equals((Object)column.getMode())) {
                    sorter.addToSortFields(new SortField(column.getName(), Order.INCREASE));
                    continue;
                }
                if (!SearchSortMode.DESC.equals((Object)column.getMode())) continue;
                sorter.addToSortFields(new SortField(column.getName(), Order.DECREASE));
            }
            searchParams.setSort(sorter);
        }
        if (rankBuilder != null) {
            Rank rank = new Rank();
            rank.setFirstRankName(rankBuilder.build().getFirstRankName());
            rank.setSecondRankName(rankBuilder.build().getSecondRankName());
            rank.setReRankSize(rankBuilder.build().getReRankSize());
            searchParams.setRank(rank);
        }
        if (aggregateBuilder != null) {
            Object aggregateColumns = aggregateBuilder.build();
            iterator = aggregateColumns.iterator();
            while (iterator.hasNext()) {
                AggregateBuilder.AggregateColumn aggregateColumn = (AggregateBuilder.AggregateColumn)iterator.next();
                Aggregate aggregate = new Aggregate();
                aggregate.setGroupKey(aggregateColumn.getName());
                StringBuilder aggFuncBuilder = new StringBuilder();
                if (aggregateColumn.isNested()) {
                    aggFuncBuilder.append("count()");
                }
                for (int i = 0; i < aggregateColumn.getFunctions().size(); ++i) {
                    AggregateBuilder.AggregateFunction aggregateFunction = aggregateColumn.getFunctions().get(i);
                    if (i > 0) {
                        aggFuncBuilder.append("#");
                    }
                    if (AggregateBuilder.FuncName.SUM.equals((Object)aggregateFunction.getFuncName())) {
                        aggFuncBuilder.append("sum(").append(aggregateFunction.getColumnName()).append(")");
                    }
                    if (AggregateBuilder.FuncName.MAX.equals((Object)aggregateFunction.getFuncName())) {
                        aggFuncBuilder.append("max(").append(aggregateFunction.getColumnName()).append(")");
                    }
                    if (AggregateBuilder.FuncName.MIN.equals((Object)aggregateFunction.getFuncName())) {
                        aggFuncBuilder.append("min(").append(aggregateFunction.getColumnName()).append(")");
                    }
                    if (!AggregateBuilder.FuncName.COUNT.equals((Object)aggregateFunction.getFuncName())) continue;
                    aggFuncBuilder.append("count()");
                }
                aggregate.setAggFun(aggFuncBuilder.toString());
                FilterCondition filterCondition = aggregateColumn.filterBuilder().build();
                if (filterCondition != null) {
                    aggregate.setAggFilter(OpenSearchFilterBuilder.INSTANCE.build(filterCondition));
                }
                searchParams.addToAggregates(aggregate);
            }
        }
        try {
            JSONObject responseResult;
            this.logger.debug("search params: {}", (Object)searchParams.toString());
            SearchResult searchResult = searchClient.execute(searchParams);
            String resultJsonStr = searchResult.getResult();
            this.logger.debug("search result: {}", (Object)resultJsonStr);
            JSONObject resultJson = new JSONObject(resultJsonStr);
            Result result = new Result();
            SearchResultDebug searchdebugrst = searchClient.executeDebug(searchParams);
            this.logger.debug("search url: {}", (Object)searchdebugrst.getRequestUrl());
            if (resultJson.get("status").equals("OK")) {
                result.setStatus(true);
                responseResult = resultJson.getJSONObject("result");
                result.setTotal(responseResult.getLong("viewtotal"));
                result.setItems(responseResult.getJSONArray("items"));
                result.setAggs(responseResult.getJSONArray("facet"));
            } else {
                responseResult = resultJson.getJSONObject("result");
                result.setTotal(responseResult.getLong("viewtotal"));
                result.setItems(responseResult.getJSONArray("items"));
                result.setAggs(responseResult.getJSONArray("facet"));
                result.setErrors(resultJson.getJSONArray("errors"));
            }
            return result;
        }
        catch (OpenSearchClientException | OpenSearchException e) {
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }
}

