/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.file;

import com.aliyun.oss.model.OSSObjectSummary;
import com.ohaotian.base.file.ftp.FtpConfig;
import com.ohaotian.base.file.ftp.FtpUtil;
import com.ohaotian.base.file.oss.OssConfig;
import com.ohaotian.base.file.oss.OssUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileProcessing {
    private static final Logger log = LogManager.getLogger(FileProcessing.class);
    private static Properties prop;
    public static String fileHost;
    public static String fileUser;
    public static String filePwd;
    public static Integer filePort;
    public static Integer timeOut;
    public static String sysFtpRootPath;
    private static String endpoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String bucketName;
    private static String accessUrl;
    private static boolean nativeOSS;
    private static FtpConfig ftpConfig;
    private static OssConfig ossConfig;
    public static String esbFtpUpload;
    public static String esbFtpDowload;
    public static String ossBasePath;

    public static OssConfig getOssConfig() {
        return ossConfig;
    }

    public void setProp(Properties prop) {
        FileProcessing.prop = prop;
        fileHost = FileProcessing.prop.getProperty("FILE_HOST").trim();
        fileUser = FileProcessing.prop.getProperty("FILE_USER").trim();
        filePwd = FileProcessing.prop.getProperty("FILE_PWD").trim();
        filePort = Integer.parseInt(FileProcessing.prop.getProperty("FILE_PORT").trim());
        timeOut = Integer.parseInt(FileProcessing.prop.getProperty("TIME_OUT").trim());
        sysFtpRootPath = FileProcessing.prop.getProperty("FILE_UPLOAD_PATH").trim();
        endpoint = FileProcessing.prop.getProperty("OSS_ENDPOINT", "").trim();
        accessKeyId = FileProcessing.prop.getProperty("OSS_ACCESSKEY", "").trim();
        accessKeySecret = FileProcessing.prop.getProperty("OSS_ACCESSKEY_SECRET", "").trim();
        nativeOSS = Boolean.parseBoolean(FileProcessing.prop.getProperty("OSS_NATIVE", "false"));
        bucketName = FileProcessing.prop.getProperty("OSS_BUCKETNAME", "").trim();
        accessUrl = FileProcessing.prop.getProperty("OSS_ACCESS_URL", "").trim();
        ossBasePath = FileProcessing.prop.getProperty("OSS_BASE_PATH", "").trim();
        ossConfig = new OssConfig(endpoint, accessKeyId, accessKeySecret, bucketName, accessUrl);
        ftpConfig = new FtpConfig(fileHost, fileUser, filePwd, filePort, timeOut);
        esbFtpUpload = FileProcessing.prop.getProperty("ESB_FTP_UPLOAD").trim();
        esbFtpDowload = FileProcessing.prop.getProperty("ESB_FTP_DOWLOAD").trim();
    }

    public static File downloadFile(String fileName, String sysCenter, String businessType) {
        File file = null;
        file = nativeOSS ? OssUtil.downloadFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName, ossConfig) : FtpUtil.downloadFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName, ftpConfig);
        return file;
    }

    public static File downLoadFileFromEsb(String fileName) {
        return FtpUtil.downloadFile(esbFtpDowload + fileName, ftpConfig);
    }

    public static File downloadFileFromOss(String fileName) {
        String filePath = ossBasePath + "/" + fileName;
        File file = OssUtil.downloadFile(filePath, ossConfig);
        return file;
    }

    public static InputStream downloadInputStreamFromOss(String fileName) {
        return OssUtil.downloadByInputStream(fileName, ossConfig);
    }

    private static String getSysFileServicePath(String sysCenter, String businessType) {
        String filePath = null;
        if ("card".equals(sysCenter)) {
            filePath = prop.getProperty("FILE_UPLOAD_PATH").trim();
            if (nativeOSS) {
                filePath = filePath.substring(1);
            }
        } else if ("num".equals(sysCenter)) {
            filePath = prop.getProperty("FILE_UPLOAD_PATH").trim();
            if (nativeOSS) {
                filePath = filePath.substring(1);
            }
        } else {
            filePath = prop.getProperty("FILE_UPLOAD_PATH").trim();
            if (nativeOSS) {
                filePath = filePath.substring(1);
            }
        }
        return filePath;
    }

    public static String upLoadFile(File file, String businessType, String sysCenter, boolean isNeedNewName) throws Exception {
        String fileName = file.getName();
        if (isNeedNewName) {
            fileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        if (nativeOSS) {
            OssUtil.uploadFile(file, ossConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
        } else {
            FtpUtil.uploadFile(file, ftpConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
        }
        return fileName;
    }

    public static String upLoadFileToEsb(File file, String businessType, String sysCenter, boolean isNeedNewName) throws Exception {
        String fileName = file.getName();
        if (isNeedNewName) {
            fileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        FtpUtil.uploadFile(file, ftpConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
        return fileName;
    }

    public static String uploadFileToOss(String localFilePath, String uploadPath) {
        File file = new File(localFilePath);
        OssUtil.uploadFile(file, ossConfig, uploadPath);
        return "";
    }

    public static String uploadFileToOSSByInputStream(String fileName, InputStream inputStream, String qserviceId) {
        String filePath = ossBasePath + "/" + fileName;
        OssUtil.uploadFileToOssByInputStream(filePath, ossConfig, inputStream);
        return filePath;
    }

    public static List<String> listFiles(String suffix) {
        return FtpUtil.listFiles(esbFtpDowload, suffix, ftpConfig);
    }

    public static String uploadFileByInputStream(String fileName, InputStream inputStream, String businessType, String sysCenter, boolean isNeedNewName) {
        if (isNeedNewName) {
            fileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        if (nativeOSS) {
            OssUtil.uploadFileByInputStream(fileName, ossConfig, inputStream, FileProcessing.getSysFileServicePath(sysCenter, businessType));
        } else {
            FtpUtil.uploadFileByInputStream(fileName, ftpConfig, inputStream, FileProcessing.getSysFileServicePath(sysCenter, businessType));
        }
        return fileName;
    }

    public static void uploadFileByInputStream(String fileName, InputStream inputStream) {
        try {
            FtpUtil.uploadFileByInputStream(fileName, ftpConfig, inputStream, esbFtpUpload);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mergeFile(File file, InputStream is) throws Exception {
        log.debug("-----mergeFile start -----");
        try (FilterOutputStream bos = null;){
            bos = new BufferedOutputStream(new FileOutputStream(file, true));
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = is.read(buf)) != -1) {
                ((BufferedOutputStream)bos).write(buf, 0, len);
            }
            ((BufferedOutputStream)bos).flush();
            log.debug("-----mergeFile success -----");
        }
        log.debug("-----mergeFile end -----");
    }

    public static void deleteFile(String fileName, String sysCenter, String businessType) {
        if (nativeOSS) {
            OssUtil.deleteFile(FileProcessing.getSysFileServicePath(sysCenter, businessType), ossConfig);
        } else {
            FtpUtil.deleteFile(FileProcessing.getSysFileServicePath(sysCenter, businessType), ftpConfig);
        }
    }

    public static String uploadToOssPath(String filePath, String ossPath, Boolean needReName) throws IOException {
        String fileName = "";
        try {
            if (needReName.booleanValue()) {
                filePath = FileProcessing.fileReName(filePath);
            }
            File file = new File(filePath);
            OssUtil.uploadFile(file, ossConfig, ossPath.trim());
            fileName = file.getName();
        }
        catch (IOException io) {
            throw new IOException(io);
        }
        catch (RuntimeException re) {
            throw new RuntimeException(re);
        }
        return fileName;
    }

    public static File downloadFromOssPath(String fileName, String ossPath) {
        try {
            String path = ossPath.trim() + fileName;
            File file = OssUtil.downloadFile(path, ossConfig);
            return file;
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
    }

    public static String uploadToOssByBusiPath(String oldFilePath, String ossPathConstant, boolean needReName) {
        try {
            if (needReName) {
                oldFilePath = FileProcessing.fileReName(oldFilePath);
            }
            File file = new File(oldFilePath);
            String fileName = FileProcessing.uploadToOssByBusiPathFile(file, ossPathConstant);
            return fileName;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
    }

    public static String uploadToOssByBusiPathFile(File file, String ossPathConstant) {
        String fileName = "";
        try {
            String ossFilePath = ossBasePath + prop.getProperty(ossPathConstant, "").trim();
            OssUtil.uploadFile(file, ossConfig, ossFilePath);
            fileName = file.getName();
            return fileName;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
    }

    public static File downloadFromOssByBusiPath(String fileName, String ossPathConstant) {
        try {
            String ossFilePath = ossBasePath + prop.getProperty(ossPathConstant, "").trim();
            String path = ossFilePath + fileName;
            File file = OssUtil.downloadFile(path, ossConfig);
            return file;
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
    }

    public static String uploadToOssByBusiPathInputStream(String fileName, String ossPathConstant, InputStream inputStream) {
        try {
            String ossFilePath = ossBasePath + prop.getProperty(ossPathConstant, "").trim();
            String filePath = ossFilePath + fileName;
            OssUtil.uploadFileToOssByInputStream(filePath, ossConfig, inputStream);
            return filePath;
        }
        catch (Exception e) {
            log.error("\u6d41\u5f0f\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
    }

    public static InputStream downloadFromOssByBusiPathInputStream(String fileName, String ossPathConstant) {
        try {
            String ossFilePath = ossBasePath + prop.getProperty(ossPathConstant, "").trim();
            String filePath = ossFilePath + fileName;
            return OssUtil.downloadByInputStream(filePath, ossConfig);
        }
        catch (Exception e) {
            log.error("\u6d41\u5f0f\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            return null;
        }
    }

    public static boolean deleteOssFileByBusiPath(String fileName, String ossPathConstant) {
        try {
            String ossFilePath = ossBasePath + prop.getProperty(ossPathConstant, "").trim();
            String filePath = ossFilePath + fileName;
            return OssUtil.deleteFileByBusiPath(filePath, ossConfig);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            return false;
        }
    }

    public static List<String> listFromOssByNameAndBusiPath(String fileName, String ossPathConstant, boolean readSubFile) {
        ArrayList<String> filePathList = new ArrayList<String>();
        try {
            String ossFilePath = ossBasePath + prop.getProperty(ossPathConstant, "").trim();
            List<OSSObjectSummary> sums = OssUtil.listByBusiPath(ossFilePath, ossConfig, readSubFile);
            for (OSSObjectSummary s : sums) {
                log.info("\t" + s.getKey());
                if (!s.getKey().contains(fileName)) continue;
                filePathList.add(s.getKey());
            }
            if (filePathList.size() == 0) {
                log.info("oss\u8def\u5f84[" + ossFilePath + "]\u4e0b\uff0c\u6a21\u7cca\u67e5\u8be2[\" + fileName + \"],\u672a\u627e\u5230\u6587\u4ef6\u3002");
            }
            return filePathList;
        }
        catch (Exception e) {
            log.error("\u6d41\u5f0f\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            return filePathList;
        }
    }

    private static String fileReName(String filePath) throws IOException {
        String newPath = String.valueOf(UUID.randomUUID());
        if (filePath.lastIndexOf(".") >= 0) {
            newPath = newPath + filePath.substring(filePath.lastIndexOf("."), filePath.length());
        }
        String dir = System.getProperty("java.io.tmpdir");
        newPath = dir + File.separator + newPath;
        FileProcessing.copy(filePath, newPath);
        return newPath;
    }

    private static void copy(String url1, String url2) throws IOException {
        FileInputStream in = new FileInputStream(new File(url1));
        FileOutputStream out = new FileOutputStream(new File(url2));
        byte[] buff = new byte[512];
        int n = 0;
        while ((n = in.read(buff)) != -1) {
            out.write(buff, 0, n);
        }
        out.flush();
        in.close();
        out.close();
    }

    public static void main(String[] args) {
    }

    static {
        nativeOSS = false;
    }
}

