/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.file;

import com.ohaotian.base.file.ftp.FtpConfig;
import com.ohaotian.base.file.ftp.FtpUtil;
import com.ohaotian.base.file.oss.OssConfig;
import com.ohaotian.base.file.oss.OssUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProcessing {
    private static final Logger log = LoggerFactory.getLogger(FileProcessing.class);
    private static Properties prop;
    public static String fileHost;
    public static String fileUser;
    public static String filePwd;
    public static Integer filePort;
    public static Integer timeOut;
    public static String sysFtpRootPath;
    private static String endpoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String bucketName;
    private static String accessUrl;
    private static boolean nativeOSS;
    private static FtpConfig ftpConfig;
    private static OssConfig ossConfig;
    public static String esbFtpUpload;
    public static String esbFtpDowload;
    public static String ossBasePath;

    public static OssConfig getOssConfig() {
        return ossConfig;
    }

    public void setProp(Properties prop) {
        FileProcessing.prop = prop;
        fileHost = FileProcessing.prop.getProperty("FILE_HOST").trim();
        fileUser = FileProcessing.prop.getProperty("FILE_USER").trim();
        filePwd = FileProcessing.prop.getProperty("FILE_PWD").trim();
        filePort = Integer.parseInt(FileProcessing.prop.getProperty("FILE_PORT").trim());
        timeOut = Integer.parseInt(FileProcessing.prop.getProperty("TIME_OUT").trim());
        sysFtpRootPath = FileProcessing.prop.getProperty("FILE_UPLOAD_PATH").trim();
        endpoint = FileProcessing.prop.getProperty("OSS_ENDPOINT", "").trim();
        accessKeyId = FileProcessing.prop.getProperty("OSS_ACCESSKEY", "").trim();
        accessKeySecret = FileProcessing.prop.getProperty("OSS_ACCESSKEY_SECRET", "").trim();
        nativeOSS = Boolean.parseBoolean(FileProcessing.prop.getProperty("OSS_NATIVE", "false"));
        bucketName = FileProcessing.prop.getProperty("OSS_BUCKETNAME", "").trim();
        accessUrl = FileProcessing.prop.getProperty("OSS_ACCESS_URL", "").trim();
        ossBasePath = FileProcessing.prop.getProperty("OSS_BASE_PATH", "").trim();
        ossConfig = new OssConfig(endpoint, accessKeyId, accessKeySecret, bucketName, accessUrl);
        ftpConfig = new FtpConfig(fileHost, fileUser, filePwd, filePort, timeOut);
        esbFtpUpload = FileProcessing.prop.getProperty("ESB_FTP_UPLOAD").trim();
        esbFtpDowload = FileProcessing.prop.getProperty("ESB_FTP_DOWLOAD").trim();
    }

    public static File downloadFile(String fileName, String sysCenter, String businessType) {
        File file = null;
        file = nativeOSS ? OssUtil.downloadFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName, ossConfig) : FtpUtil.downloadFile(FileProcessing.getSysFileServicePath(sysCenter, businessType) + fileName, ftpConfig);
        return file;
    }

    public static File downLoadFileFromEsb(String fileName) {
        return FtpUtil.downloadFile(esbFtpDowload + fileName, ftpConfig);
    }

    public static File downloadFileFromOss(String fileName) {
        String filePath = ossBasePath + "/" + fileName;
        File file = OssUtil.downloadFile(filePath, ossConfig);
        return file;
    }

    public static InputStream downloadInputStreamFromOss(String fileName) {
        return OssUtil.downloadByInputStream(fileName, ossConfig);
    }

    private static String getSysFileServicePath(String sysCenter, String businessType) {
        String filePath = null;
        if ("card".equals(sysCenter)) {
            filePath = prop.getProperty("FILE_UPLOAD_PATH").trim();
            if (nativeOSS) {
                filePath = filePath.substring(1);
            }
        } else if ("num".equals(sysCenter)) {
            filePath = prop.getProperty("FILE_UPLOAD_PATH").trim();
            if (nativeOSS) {
                filePath = filePath.substring(1);
            }
        } else {
            filePath = prop.getProperty("FILE_UPLOAD_PATH").trim();
            if (nativeOSS) {
                filePath = filePath.substring(1);
            }
        }
        return filePath;
    }

    public static String upLoadFile(File file, String businessType, String sysCenter, boolean isNeedNewName) {
        String fileName = file.getName();
        if (isNeedNewName) {
            fileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        if (nativeOSS) {
            OssUtil.uploadFile(file, ossConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
        } else {
            FtpUtil.uploadFile(file, ftpConfig, FileProcessing.getSysFileServicePath(sysCenter, businessType));
        }
        return fileName;
    }

    public static String uploadFileToOss(String localFilePath, String uploadPath) {
        File file = new File(localFilePath);
        OssUtil.uploadFile(file, ossConfig, uploadPath);
        return "";
    }

    public static String uploadFileToOSSByInputStream(String fileName, InputStream inputStream, String qserviceId) {
        Calendar cal = Calendar.getInstance();
        String currentDate = DateFormatUtils.format((Calendar)cal, (String)"yyyyMMdd");
        String filePath = ossBasePath + "/" + fileName;
        OssUtil.uploadFileToOssByInputStream(filePath, ossConfig, inputStream);
        return filePath;
    }

    public static List<String> listFiles(String suffix) {
        return FtpUtil.listFiles(esbFtpDowload, suffix, ftpConfig);
    }

    public static String uploadFileByInputStream(String fileName, InputStream inputStream, String businessType, String sysCenter, boolean isNeedNewName) {
        if (isNeedNewName) {
            fileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        if (nativeOSS) {
            OssUtil.uploadFileByInputStream(fileName, ossConfig, inputStream, FileProcessing.getSysFileServicePath(sysCenter, businessType));
        } else {
            FtpUtil.uploadFileByInputStream(fileName, ftpConfig, inputStream, FileProcessing.getSysFileServicePath(sysCenter, businessType));
        }
        return fileName;
    }

    public static void uploadFileByInputStream(String fileName, InputStream inputStream) {
        try {
            FtpUtil.uploadFileByInputStream(fileName, ftpConfig, inputStream, esbFtpUpload);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mergeFile(File file, InputStream is) throws Exception {
        log.debug("-----mergeFile start -----");
        try (FilterOutputStream bos = null;){
            bos = new BufferedOutputStream(new FileOutputStream(file, true));
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = is.read(buf)) != -1) {
                ((BufferedOutputStream)bos).write(buf, 0, len);
            }
            ((BufferedOutputStream)bos).flush();
            log.debug("-----mergeFile success -----");
        }
        log.debug("-----mergeFile end -----");
    }

    public static void deleteFile(String fileName, String sysCenter, String businessType) {
        if (nativeOSS) {
            OssUtil.deleteFile(FileProcessing.getSysFileServicePath(sysCenter, businessType), ossConfig);
        } else {
            FtpUtil.deleteFile(FileProcessing.getSysFileServicePath(sysCenter, businessType), ftpConfig);
        }
    }

    public static void main(String[] args) {
    }

    static {
        nativeOSS = false;
    }
}

