/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.log;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class LogContextLoaderListener
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger(LogContextLoaderListener.class.getName());
    private static final PathMatchingResourcePatternResolver PMRPR = new PathMatchingResourcePatternResolver(LogContextLoaderListener.class.getClassLoader());
    private String logConfigFile;
    private String defaultLogPrefix;
    private LoggerContext loggerContext;
    private List<String> configFileList = new LinkedList<String>();

    public LogContextLoaderListener() {
        String configFile = "log4j2.xml";
        this.initDefaultLoadConfigFile(configFile);
        configFile = "log4j.xml";
        this.initDefaultLoadConfigFile(configFile);
        configFile = "log4j.properties";
        this.initDefaultLoadConfigFile(configFile);
    }

    private void initDefaultLoadConfigFile(String configFile) {
        this.configFileList.add("classpath:/" + configFile);
        this.configFileList.add("classpath:/config/" + configFile);
        this.configFileList.add("classpath:/../config/" + configFile);
        this.configFileList.add("classpath:/../../config/" + configFile);
        this.configFileList.add("classpath:/../../../config/" + configFile);
        this.configFileList.add("classpath:/../../../../config/" + configFile);
        this.configFileList.add("classpath:/../../../../../config/" + configFile);
        this.configFileList.add("classpath:/../../../../../../config/" + configFile);
        this.configFileList.add("classpath:/../../../../../../../config/" + configFile);
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        String string = this.defaultLogPrefix = servletContext == null ? null : servletContext.getInitParameter("defaultLogPrefix");
        if (this.defaultLogPrefix == null || "".equals(this.defaultLogPrefix)) {
            this.defaultLogPrefix = "file:";
        }
        this.logConfigFile = System.getProperty("logConfigFile");
        if (this.logConfigFile == null || "".equals(this.logConfigFile)) {
            String string2 = this.logConfigFile = servletContext == null ? null : servletContext.getInitParameter("logConfigFile");
        }
        if (this.logConfigFile == null || "".equals(this.logConfigFile)) {
            throw new RuntimeException("log config is required !!!");
        }
        if (!this.logConfigFile.startsWith("file:") && !this.logConfigFile.startsWith("classpath:")) {
            this.logConfigFile = this.defaultLogPrefix + this.logConfigFile;
        }
        this.configFileList.add(0, this.logConfigFile);
        for (String configFile : this.configFileList) {
            if (this.doLogConfig(configFile)) {
                this.logConfigFile = configFile;
                break;
            }
            logger.info("load log config[" + configFile + "] failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doLogConfig(String configFile) {
        Resource logResource = this.extractLogConfigFileResource(configFile);
        if (!logResource.exists()) {
            return false;
        }
        boolean configLoaded = false;
        InputStream logInput = null;
        try {
            logInput = logResource.getInputStream();
            ConfigurationSource source = new ConfigurationSource(logInput);
            this.loggerContext = Configurator.initialize((ClassLoader)this.getClass().getClassLoader(), (ConfigurationSource)source);
            configLoaded = true;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "load log config [" + configFile + "] error:" + e.getMessage());
        }
        finally {
            if (logInput != null) {
                try {
                    logInput.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "close log config [" + configFile + "] stream error:" + e.getMessage());
                }
            }
        }
        return configLoaded;
    }

    private Resource extractLogConfigFileResource(String configFile) {
        String classpathPro = "classpath:";
        if (configFile.startsWith(classpathPro)) {
            try {
                String formatedFilePath = configFile.replace("/", File.separator).substring(classpathPro.length());
                File tmpFile = new File(PMRPR.getResource(classpathPro + "./").getFile().getCanonicalPath() + File.separator + formatedFilePath);
                formatedFilePath = "file:" + tmpFile.getCanonicalPath();
                logger.info("trans path[" + configFile + "] to path[" + formatedFilePath + "].");
                configFile = formatedFilePath;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "trans path[" + configFile + "] to canonicalPath error:" + e.getMessage());
            }
        }
        logger.info("load log config. logConfigFile:[" + configFile + "]");
        return PMRPR.getResource(configFile);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (this.loggerContext != null) {
            logger.info("unload log config. logConfigFile:[" + this.logConfigFile + "]");
            Configurator.shutdown((LoggerContext)this.loggerContext);
        }
    }
}

