package com.tydic.base.mock;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

import java.lang.reflect.Field;

/** <br>
 * 标题: 注解处理器<br>
 * 描述: 用于处理注解<br>
 * 公司: www.tydic.com<br>
 *
 * @author zhangcheng
 * @date 2018/03/05
 */
public interface AnnotationHandle {

    /**
     * 校验字段上存在该注解
     * @param field 字段
     * @return
     */
    boolean hasExist(Field field);

    /**
     * 执行该注解的处理逻辑
     * @param bean Bean对象
     * @param beanName 对象名称
     * @param field 字段
     * @param applicationContext Spring容器
     * @return
     * @throws BeansException
     */
    Object invok(Object bean,String beanName,Field field,ApplicationContext applicationContext)throws BeansException;

}
