/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.mq.util;

import com.aliyun.openservices.ons.api.Message;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.base.common.bo.ReqInfoBO;
import com.ohaotian.base.common.bo.RspInfoBO;
import com.ohaotian.base.mq.MqMessageListener;
import com.ohaotian.base.mq.MqProducerPool;
import com.ohaotian.base.mq.bo.ReqInfceBaseBO;
import com.ohaotian.base.mq.bo.RspIntfaceBaseBO;
import com.ohaotian.base.mq.interfce.MqCunsumer;
import com.ohaotian.base.mq.util.AOPErrorLogger;
import com.ohaotian.base.mq.util.AOPLogger;
import com.ohaotian.base.mq.util.BusiErrorLogger;
import com.ohaotian.base.mq.util.BusiLogger;
import com.ohaotian.base.mq.util.MQErrorLogger;
import com.ohaotian.base.mq.util.MQLogger;
import com.ohaotian.base.mq.util.ThrowableInfoUtils;
import com.taobao.eagleeye.EagleEye;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static final Logger log = LoggerFactory.getLogger(LogUtils.class);
    private static final Logger aoplog = LoggerFactory.getLogger(AOPLogger.class);
    private static final Logger busilog = LoggerFactory.getLogger(BusiLogger.class);
    private static final Logger mqlog = LoggerFactory.getLogger(MQLogger.class);
    private static final Logger aopErrorLog = LoggerFactory.getLogger(AOPErrorLogger.class);
    private static final Logger busiErrorLog = LoggerFactory.getLogger(BusiErrorLogger.class);
    private static final Logger mqErrorLog = LoggerFactory.getLogger(MQErrorLogger.class);
    private static final String SEPARATOR = "|";
    private static final String CLASS_METHOD_SEPARATOR = ".";
    private static final String START_IDENTIFICATION = "1";
    private static final String END_IDENTIFICATION = "2";
    private static final String ERROR_IDENTIFICATION = "0";
    private static final String MQPRODUCER = "1";
    private static final String MQCONSUMER = "2";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Map<String, String[]> classNameMap = new ConcurrentHashMap<String, String[]>();
    private static final String CONSUMER_METHOD_NAME = "execute";
    private static final String excludeMethods = "subscribe";
    private static Properties propertyConfigurer;

    public Properties getPropertyConfigurer() {
        return propertyConfigurer;
    }

    public void setPropertyConfigurer(Properties propertyConfigurer) {
        LogUtils.propertyConfigurer = propertyConfigurer;
    }

    public static final String[] printAopStartLog(ProceedingJoinPoint pjp) {
        Long nowTime = System.currentTimeMillis();
        String[] infos = new String[21];
        String className = pjp.getTarget().getClass().getName();
        String methodString = pjp.getSignature().getName();
        if (excludeMethods.equals(methodString) || CONSUMER_METHOD_NAME.equals(methodString)) {
            return null;
        }
        String traceId = LogUtils.getTraceId();
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = MqMessageListener.traceIds.get();
        }
        StringBuilder classAndMethod = new StringBuilder();
        classAndMethod.append(className);
        classAndMethod.append(CLASS_METHOD_SEPARATOR);
        classAndMethod.append(methodString);
        infos[0] = traceId;
        infos[1] = "";
        infos[2] = classAndMethod.toString();
        infos[3] = "1";
        infos[4] = "1";
        infos[5] = nowTime.toString();
        infos[6] = "";
        Object[] params = pjp.getArgs();
        ReqInfceBaseBO req = null;
        ReqInfoBO reqinfo = null;
        if (params != null && params.length > 0) {
            if (params[0] instanceof ReqInfceBaseBO) {
                req = (ReqInfceBaseBO)params[0];
                String reqNo = req.getReqNo();
                if (StringUtils.isBlank((CharSequence)reqNo)) {
                    reqNo = "";
                }
                infos[7] = reqNo;
                infos[8] = req.getSerialNumberBase();
                infos[9] = req.getIccidBase();
                infos[10] = req.getProvinceCode();
                infos[11] = req.getCityCode();
                infos[12] = req.getDistrictCode();
                infos[13] = req.getDepartId();
                infos[14] = req.getChannelId();
                infos[15] = req.getProvinceCode() + "_" + req.getStaffId();
                try {
                    infos[16] = mapper.writeValueAsString(params[0]);
                }
                catch (JsonProcessingException e) {
                    infos[16] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + params[0]).replace("\r\n", "");
                }
                infos[17] = "";
                infos[18] = "";
                infos[19] = "";
                infos[20] = "";
            } else if (params[0] instanceof ReqInfoBO) {
                reqinfo = (ReqInfoBO)params[0];
                String reqNo = reqinfo.getReqNo();
                if (StringUtils.isBlank((CharSequence)reqNo)) {
                    reqNo = "";
                }
                infos[7] = reqNo;
                infos[8] = reqinfo.getSerialNumberBase();
                infos[9] = reqinfo.getIccidBase();
                infos[10] = reqinfo.getProvinceCode();
                infos[11] = reqinfo.getCityCode();
                infos[12] = reqinfo.getDistrictCode();
                infos[13] = reqinfo.getDepartId();
                infos[14] = reqinfo.getChannelId();
                infos[15] = reqinfo.getStaffId();
                try {
                    infos[16] = mapper.writeValueAsString(params[0]);
                }
                catch (JsonProcessingException e) {
                    infos[16] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + params[0]).replace("\r\n", "");
                }
                infos[17] = "";
                infos[18] = "";
                infos[19] = "";
                infos[20] = "";
            }
        }
        aoplog.info(LogUtils.getLogInfoByStrings(infos));
        return infos;
    }

    public static void printAopErrorLog(String[] infos, String keyWord, Throwable e) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[3] = ERROR_IDENTIFICATION;
        infos[6] = nowTime.toString();
        infos[18] = "8888";
        infos[20] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
        aopErrorLog.error(LogUtils.getLogInfoByStrings(infos));
    }

    public static void printAopEndLog(String[] infos, String keyWord, Object obj) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[3] = "2";
        infos[6] = nowTime.toString();
        if (obj != null && obj instanceof RspIntfaceBaseBO) {
            RspIntfaceBaseBO o = (RspIntfaceBaseBO)obj;
            try {
                infos[17] = mapper.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                infos[17] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + obj).replace("\r\n", "");
            }
            infos[18] = o.getRespCode();
            infos[19] = o.getRespDesc();
        } else if (obj != null && obj instanceof RspInfoBO) {
            RspInfoBO o = (RspInfoBO)obj;
            try {
                infos[17] = mapper.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                infos[17] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + obj).replace("\r\n", "");
            }
            infos[18] = o.getRespCode();
            infos[19] = o.getRespDesc();
        }
        aoplog.info(LogUtils.getLogInfoByStrings(infos));
    }

    public static final void printMQProducerLog(String className, String method, Message msg, Object body) {
        Long nowTime = System.currentTimeMillis();
        String[] infos = new String[18];
        StringBuilder classAndMethod = new StringBuilder();
        classAndMethod.append(className);
        classAndMethod.append(CLASS_METHOD_SEPARATOR);
        classAndMethod.append(method);
        infos[0] = msg.getUserProperties("TraceId");
        infos[1] = "";
        infos[2] = classAndMethod.toString();
        infos[3] = "1";
        infos[4] = "1";
        infos[5] = "1.1";
        infos[6] = nowTime.toString();
        infos[7] = infos[6];
        infos[8] = MqProducerPool.producerIds.get(msg.getTopic());
        infos[9] = msg.getTopic();
        infos[10] = msg.getTag();
        infos[11] = "";
        infos[12] = msg.getMsgID();
        infos[13] = msg.getKey();
        infos[14] = "";
        infos[15] = "";
        try {
            infos[16] = mapper.writeValueAsString(body);
        }
        catch (JsonProcessingException e) {
            infos[16] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + body).replace("\r\n", "");
        }
        mqlog.info(LogUtils.getLogInfoByStrings(infos));
    }

    public static void printMQErrorLog(String className, String method, Message msg, Object body, Throwable e) {
        Long nowTime = System.currentTimeMillis();
        String[] infos = new String[18];
        StringBuilder classAndMethod = new StringBuilder();
        classAndMethod.append(className);
        classAndMethod.append(CLASS_METHOD_SEPARATOR);
        classAndMethod.append(method);
        infos[0] = msg.getUserProperties("TraceId");
        infos[1] = "";
        infos[2] = classAndMethod.toString();
        infos[3] = "1";
        infos[4] = ERROR_IDENTIFICATION;
        infos[5] = "1.1";
        infos[6] = nowTime.toString();
        infos[7] = infos[6];
        infos[8] = MqProducerPool.producerIds.get(msg.getTopic());
        infos[9] = msg.getTopic();
        infos[10] = msg.getTag();
        infos[11] = "";
        infos[12] = msg.getMsgID();
        infos[13] = msg.getKey();
        infos[14] = "";
        infos[15] = "";
        try {
            infos[16] = mapper.writeValueAsString(body);
        }
        catch (JsonProcessingException ex) {
            infos[16] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + body).replace("\r\n", "");
        }
        infos[17] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
        mqErrorLog.error(LogUtils.getLogInfoByStrings(infos));
    }

    public static final String[] printMQConsumerStartLog(Message msg, MqCunsumer consumer, Object obj) {
        String[] infos = LogUtils.getMQConsumerStartLog(msg, consumer, obj);
        mqlog.info(LogUtils.getLogInfoByStrings(infos));
        return infos;
    }

    public static final String[] getMQConsumerStartLog(Message msg, MqCunsumer consumer, Object obj) {
        Long nowTime = System.currentTimeMillis();
        String[] infos = new String[18];
        String className = null;
        className = Proxy.isProxyClass(consumer.getClass()) ? Proxy.getInvocationHandler(consumer).getClass().getName() : consumer.getClass().getName();
        String[] consumerInfos = classNameMap.get(className);
        if (consumerInfos == null) {
            consumerInfos = new String[]{className, propertyConfigurer.getProperty(consumer.subscribe().getConsumerId())};
            classNameMap.put(className, consumerInfos);
        }
        StringBuilder classAndMethod = new StringBuilder();
        classAndMethod.append(consumerInfos[0]);
        classAndMethod.append(CLASS_METHOD_SEPARATOR);
        classAndMethod.append(CONSUMER_METHOD_NAME);
        infos[0] = msg.getUserProperties("TraceId");
        MqMessageListener.traceIds.set(infos[0]);
        infos[1] = "";
        infos[2] = classAndMethod.toString();
        infos[3] = "2";
        infos[4] = "1";
        infos[5] = "1.1";
        infos[6] = nowTime.toString();
        infos[7] = "";
        infos[8] = consumerInfos[1];
        infos[9] = msg.getTopic();
        infos[10] = msg.getTag();
        infos[11] = "";
        infos[12] = msg.getMsgID();
        infos[13] = msg.getKey();
        infos[14] = "";
        infos[15] = "";
        if (obj != null) {
            try {
                infos[16] = mapper.writeValueAsString(obj);
            }
            catch (JsonProcessingException ex) {
                infos[16] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + obj).replace("\r\n", "");
            }
        }
        return infos;
    }

    public static void printMQConsumerEndLog(String[] infos) {
        Long nowTime = System.currentTimeMillis();
        infos[4] = "2";
        infos[7] = nowTime.toString();
        mqlog.info(LogUtils.getLogInfoByStrings(infos));
    }

    public static void printMQConsumerErrorLog(String[] infos, Throwable e) {
        Long nowTime = System.currentTimeMillis();
        infos[4] = ERROR_IDENTIFICATION;
        infos[7] = nowTime.toString();
        infos[17] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
        mqlog.info(LogUtils.getLogInfoByStrings(infos));
    }

    public static final String[] printBusiAopStartLog(ProceedingJoinPoint pjp) {
        Long nowTime = System.currentTimeMillis();
        String traceId = LogUtils.getTraceId();
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = MqMessageListener.traceIds.get();
        }
        String className = pjp.getTarget().getClass().getName();
        String methodString = pjp.getSignature().getName();
        if (excludeMethods.equals(methodString) || CONSUMER_METHOD_NAME.equals(methodString)) {
            return null;
        }
        StringBuilder classAndMethod = new StringBuilder();
        classAndMethod.append(className);
        classAndMethod.append(CLASS_METHOD_SEPARATOR);
        classAndMethod.append(methodString);
        String[] infos = new String[21];
        infos[0] = traceId;
        infos[2] = classAndMethod.toString();
        infos[3] = "1";
        infos[4] = "1.1";
        infos[5] = nowTime.toString();
        infos[6] = "";
        Object[] params = pjp.getArgs();
        if (params != null && params.length > 0) {
            if (params.length == 1) {
                try {
                    infos[16] = mapper.writeValueAsString(params[0]);
                }
                catch (JsonProcessingException e) {
                    infos[16] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + params[0]).replace("\r\n", "");
                }
            } else {
                StringBuilder paramsStr = new StringBuilder();
                paramsStr.append("[");
                for (Object obj : params) {
                    String objStr = null;
                    if (obj != null) {
                        try {
                            objStr = mapper.writeValueAsString(obj);
                        }
                        catch (JsonProcessingException e) {
                            objStr = null;
                        }
                    }
                    paramsStr.append(objStr);
                    paramsStr.append(",");
                }
                paramsStr.setLength(paramsStr.length() - 1);
                paramsStr.append("]");
                infos[16] = paramsStr.toString();
            }
        }
        busilog.info(LogUtils.getLogInfoByStrings(infos));
        return infos;
    }

    public static void printBusiAopErrorLog(String[] infos, Throwable e) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[3] = ERROR_IDENTIFICATION;
        infos[6] = nowTime.toString();
        infos[18] = "8888";
        infos[20] = ThrowableInfoUtils.getThrowableStrRep(e).replace("\r\n", "");
        busiErrorLog.error(LogUtils.getLogInfoByStrings(infos));
    }

    public static void printBusiAopEndLog(String[] infos) {
        if (infos == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        infos[3] = "2";
        infos[6] = nowTime.toString();
        busilog.info(LogUtils.getLogInfoByStrings(infos));
    }

    private static final String getLogInfoByStrings(String[] infos) {
        StringBuilder stb = new StringBuilder();
        for (String info : infos) {
            if (StringUtils.isBlank((CharSequence)info)) {
                info = "";
            }
            stb.append(info + SEPARATOR);
        }
        if (stb.length() > 1) {
            stb.setLength(stb.length() - 1);
        }
        return stb.toString();
    }

    private static final String getTraceId() {
        String traceId = EagleEye.getTraceId();
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = "";
        }
        return traceId;
    }
}

