package com.ohaotian.base.mq;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import com.ohaotian.base.cache.CacheService;
import com.ohaotian.base.mq.bo.MqConstants;
import com.ohaotian.base.mq.bo.MqSubScribeSingleBO;
import com.ohaotian.base.mq.interfce.MqCunsumer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.PropertyKeyConst;

/**
 * <br>
 * 标题: <br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * 
 * @autho liuce
 * @time 2016年8月31日 下午9:45:07
 */
public class MqCunsumerSubscribe implements ApplicationContextAware {

	private final static Logger log = LoggerFactory.getLogger(MqCunsumerSubscribe.class);

	private final boolean isDebugEnabled = log.isDebugEnabled();

	/** 本地事务接口方法集合 */
	private static Map<String, Method> localMethods = new HashMap<String, Method>();

	/** 缓存service */
	private CacheService cacheService;

	public void setCacheService(CacheService cacheService) {
		this.cacheService = cacheService;
	}

	/** 配置文件 */
	private Properties props;

	/** 是否开启本地模式 */
	private boolean nativeOns = false;

	/** 需要排除的消费者 */
	private static Set<String> excludeConsumerSet = null;
	/** 需要排除的重试消费次数的消费者 */
	private static Set<String> excludeReconsumeTimesTopicSet = null;

	/** 本地模式topic和消费者 */
	public static Map<String, List<MqCunsumer>> nativeTopics = new HashMap<String, List<MqCunsumer>>();

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {

		cacheService = applicationContext.getBean("cacheService", CacheService.class);

		props = applicationContext.getBean("propertyConfigurer", Properties.class);

		if (applicationContext.containsBean("isIntfaceProject")) {
			ProjectNameUtils pro = applicationContext.getBean("isIntfaceProject", ProjectNameUtils.class);
			if (pro.isNeedExcludeMqConsumer()) {
				String[] excludeConsumers = props.getProperty("INTERFACE_MQ_CONSUMER", "").split(",");
				excludeConsumerSet = new HashSet<String>(excludeConsumers.length);
				for (String excludeConsumer : excludeConsumers) {
					excludeConsumerSet.add(excludeConsumer.trim());
				}
			}
		}

		String accessKey = props.getProperty("ons.AccessKey");
		String secretKey = props.getProperty("ons.SecretKey");

		String namesrvAddr = props.getProperty("mq.NAMESRV_ADDR");
		String oNSAddr = props.getProperty("mq.ONSAddr");

		// 消息消费失败重试最大次数
		String maxReconsumeTimes = props.getProperty("mq.MAX_RECONSUME_TIMES");

		// 排除的topic的限制
		String excludeReconsumeTimesTopic = props.getProperty("mq.EXCLUDE_RECONSUME_TIMES_TOPIC", "");
		if (isDebugEnabled) {
			log.debug("excludeReconsumeTimesTopic=[" + excludeReconsumeTimesTopic + "]");
		}
		if (StringUtils.isNotEmpty(excludeReconsumeTimesTopic)) {
			String[] excludeReconsumeTimesTopicArry = excludeReconsumeTimesTopic.split(",");
			excludeReconsumeTimesTopicSet = new HashSet<String>(excludeReconsumeTimesTopicArry.length);
			for (String excludeTopic : excludeReconsumeTimesTopicArry) {
				excludeReconsumeTimesTopicSet.add(excludeTopic.trim());
			}
		}

		if (isDebugEnabled) {
			log.debug("namesrvAddr=" + namesrvAddr);
			log.debug("oNSAddr=" + oNSAddr);
			log.debug("maxReconsumeTimes=" + maxReconsumeTimes);
		}

		nativeOns = Boolean.parseBoolean(props.getProperty("ons.native"));

		// 获取所有的消费者
		Map<String, MqCunsumer> mqMap = applicationContext.getBeansOfType(MqCunsumer.class);
		
		Map<String, List<MqCunsumer>> mqMapList=new HashMap<String, List<MqCunsumer>>();
		for (String key : mqMap.keySet()) {
			MqCunsumer mqc = mqMap.get(key);
			final MqSubScribeSingleBO mqBO = mqc.subscribe();
			if(null==mqMapList.get(mqBO.getTopic())){
				List<MqCunsumer> mqList=new ArrayList<MqCunsumer>();
				mqList.add(mqc);
				mqMapList.put(mqBO.getTopic(), mqList);
			}else{
				mqMapList.get(mqBO.getTopic()).add(mqc);
			}
		}
		
		
		

		for (String key : mqMapList.keySet()) {
			List<MqCunsumer> mqcList = mqMapList.get(key);
			// 获取所有的注册信息
			// List<MqSubScribeInfoBO> list = mqc.subscribe();
			// for (final MqSubScribeInfoBO bo : list) {
			//
			//
			// }
			/* 避免配置出错，无法测试发版 by liuzy */
			try {
				startConsumer(accessKey, secretKey, namesrvAddr, oNSAddr, maxReconsumeTimes, mqcList);
			} catch (Throwable e) {
				log.error(e.getMessage(), e);
			}
		}

		if (nativeOns) {
			NativeMqListener mql = new NativeMqListener(cacheService);
			mql.start();
		}

	}

	private void startConsumer(String accessKey, String secretKey, String namesrvAddr, String oNSAddr,
			String maxReconsumeTimes, final List<MqCunsumer> mqcList) {

		if (mqcList != null && mqcList.size()>0) {
			final MqSubScribeSingleBO mqBO = mqcList.get(0).subscribe();

			if (mqBO != null && StringUtils.isNotBlank(mqBO.getConsumerId()) && StringUtils.isNotBlank(mqBO.getTopic())
					&& StringUtils.isNotBlank(mqBO.getTag())) {

				// 如果消费者再排除的集合中，则不注册消费者
				if (excludeConsumerSet != null && excludeConsumerSet.contains(mqBO.getConsumerId().trim())) {
					if (isDebugEnabled) {
						log.debug("排除的ConsumerId=" + mqBO.getConsumerId());
					}
					return;
				}

				Properties properties = new Properties();

				String topic = props.getProperty(mqBO.getTopic());
				if (StringUtils.isNotBlank(topic)) {
					topic = topic.trim();
				} else {
					log.error("topic为" + mqBO.getTopic() + "的消息主题配置不正确！请配置！");
				}

				// log.info("注册的ConsumerId=" + mqBO.getConsumerId());

				// 最大消息重试次数，剔除不需要限制的topic
				if (CollectionUtils.isNotEmpty(excludeReconsumeTimesTopicSet)
						&& excludeReconsumeTimesTopicSet.contains(mqBO.getTopic().trim())) {
					// properties.put(PropertyKeyConst.MaxReconsumeTimes, 16);
					// log.info(mqBO.getConsumerId() + "消费失败重试次数=" + 16);
				} else if (StringUtils.isNotBlank(maxReconsumeTimes)) {
					properties.put(PropertyKeyConst.MaxReconsumeTimes, maxReconsumeTimes);
					// log.info(mqBO.getConsumerId() + "消费失败重试次数=" + maxReconsumeTimes);
				}

				// 是否开启本地模式
				if (nativeOns) {
					nativeTopics.put(topic, mqcList);//待解决
				} else {

					String consumerId = props.getProperty(mqBO.getConsumerId());

					if (StringUtils.isNotBlank(consumerId)) {
						consumerId = consumerId.trim();
					} else {
						log.error("消费者id为" + mqBO.getConsumerId() + "的消费者配置不正确！请配置！");
					}

					properties.put(PropertyKeyConst.ConsumerId, consumerId);

					// 如果鉴权信息存在，需要添加
					if (StringUtils.isNotBlank(accessKey)) {
						properties.put(PropertyKeyConst.AccessKey, accessKey);
					}
					// 如果鉴权信息存在，需要添加
					if (StringUtils.isNotBlank(secretKey)) {
						properties.put(PropertyKeyConst.SecretKey, secretKey);
					}

					// 如果nameServer 存在后面的那个无效
					if (StringUtils.isNotBlank(namesrvAddr)) {
						properties.put(PropertyKeyConst.NAMESRV_ADDR, namesrvAddr);
						// log.debug("NAMESRV_ADDR is not null");
					}

					// 如果地址服务器存在，需要添加
					if (StringUtils.isNotBlank(oNSAddr)) {
						properties.put(PropertyKeyConst.ONSAddr, oNSAddr);
					}

					// 设置消费者线程数 如果该消费者存在对应的特殊设置，则设置他的线程数，默认为5个
					String consumeThreadNumsStr = props.getProperty(mqBO.getConsumerId() + "_THREAD_NUMS");
					if (StringUtils.isNotBlank(consumeThreadNumsStr)) {
						int consumeThreadNums = Integer.parseInt(consumeThreadNumsStr.trim());
						properties.put(PropertyKeyConst.ConsumeThreadNums, consumeThreadNums);
					} else {
						properties.put(PropertyKeyConst.ConsumeThreadNums, MqConstants.CONSUME_THREAD_NUMS);
					}

					Consumer consumer = ONSFactory.createConsumer(properties);

					//循环消费者，拼接tag，注册消费者
					String tag="";
					for(MqCunsumer mqcu:mqcList){
						MqSubScribeSingleBO mgbo=mqcu.subscribe();
						tag=tag+mgbo.getTag()+"||";
					}
					tag=tag.substring(0, tag.length()-2);

					consumer.subscribe(topic, tag, new MqMessageListener(cacheService, mqcList, mqBO.getTag()));
					// Consumer Info
					log.info("consumerInfo=" + properties.toString(), "topic=" + topic, "tag=" + tag);
					System.out.println("consumerInfo=" + properties.toString() + ", topic=" + topic + ", tag=" + tag);
					// start consumer
					consumer.start();
				}
			}
		}
	}

	/**
	 * 调用消费者指定执行的方法<br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param mQLocalExecuterService
	 * @param methodName
	 * @param args
	 * @throws Exception
	 * @autho liuce
	 * @time 2016年9月1日 下午5:00:09
	 */
	@SuppressWarnings("unused")
	private void invokeMethod(final Object service, String methodName, Object args) throws Exception {

		// 需要执行的方法
		Method method = localMethods.get(service + methodName);
		if (method == null) {

			Class<?> c = service.getClass();
			for (Method m : c.getDeclaredMethods()) {
				if (methodName.equals(m.getName())) {
					localMethods.put(service + methodName, m);
					method = m;
					break;
				}
			}
		}

		method.invoke(service, args);

	}

}
