package com.ohaotian.base.mq;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import com.ohaotian.base.cache.CacheService;
import com.ohaotian.base.mq.bo.MqProduceSingleBO;
import com.ohaotian.base.mq.interfce.MqProduceService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.PropertyKeyConst;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/** <br>
 * 标题: 事务生产者连接池<br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * 
 * @autho liuce
 * @time 2016年9月1日 下午6:10:55 */
public class MqTranProducerPool implements ApplicationContextAware {

	private static final Logger              log                = LoggerFactory.getLogger(MqTranProducerPool.class);

	/** 所有的topic 对应的生产者 */
	private Map<String, TransactionProducer> producers          = new HashMap<String, TransactionProducer>();

	/** 本地事务检查机制 */
	private LocalTransactionChecker          localTransactionChecker;

	/** 全局配置文件 */
	private Properties                       propertyConfigurer;

	/** 是否开启本地模式 */
	private boolean                          nativeOns          = false;

	ApplicationContext applicationContext;

	/** 缓存service */
	private CacheService cacheService;

	/** 所有topic 对应的生产者配置属性 */
	private Map<String, Properties>          producerProperties = new HashMap<String, Properties>();

	/** 设置 本地事务检查机制
	 * 
	 * @param localTransactionChecker
	 *        本地事务检查机制 */
	public void setLocalTransactionChecker(LocalTransactionChecker localTransactionChecker) {
		this.localTransactionChecker = localTransactionChecker;
	}

	/** 设置 全局配置文件
	 * 
	 * @param propertyConfigurer
	 *        全局配置文件 */
	public void setPropertyConfigurer(Properties propertyConfigurer) {
		this.propertyConfigurer = propertyConfigurer;
	}

	/** 返回 全局配置文件
	 * 
	 * @return 全局配置文件 */
	public Properties getPropertyConfigurer() {
		return propertyConfigurer;
	}

	/** 返回 是否开启本地模式
	 * 
	 * @return 是否开启本地模式 */
	public boolean isNativeOns() {
		return nativeOns;
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext=applicationContext;
	}

	/** 设置 缓存service
	 * 
	 * @param cacheService
	 *        缓存service */
	public void setCacheService(CacheService cacheService) {
		this.cacheService = cacheService;
	}

	public void init() {
		String accessKey = propertyConfigurer.getProperty("ons.AccessKey");
		String secretKey = propertyConfigurer.getProperty("ons.SecretKey");
		String namesrvAddr = propertyConfigurer.getProperty("mq.NAMESRV_ADDR");
		String oNSAddr = propertyConfigurer.getProperty("mq.ONSAddr");

		nativeOns = Boolean.parseBoolean(propertyConfigurer.getProperty("ons.native"));
		//add by njg 2018-1-23 把所有的生产者拿出来
		Map<String, MqProduceService> mqMap =applicationContext.getBeansOfType(MqProduceService.class);
		//按topic放入map，相同的topic直接覆盖
		Map<String,MqProduceSingleBO> proMap=new HashMap<String,MqProduceSingleBO>();
		for (String key : mqMap.keySet()) {
			MqProduceService mqc = mqMap.get(key);
			List<MqProduceSingleBO> msList=mqc.producer();
			if(msList!=null) {
				for (MqProduceSingleBO ms:msList) {
					proMap.put(ms.getTopic(),ms);
				}
			}
		}
		//add by njg 2018-1-23 把所有的生产者拿出来

		/*for (Object o : propertyConfigurer.keySet()) {
			String key = String.valueOf(o);
			if (key.contains("_PID")) {

				String topicKey = key.substring(0, key.length() - 3) + "TOPIC";

				String topic = propertyConfigurer.getProperty(topicKey);*/
		for (String key : proMap.keySet()) {
			MqProduceSingleBO mbo=proMap.get(key);
			//String topic = propertyConfigurer.getProperty(topicKey);
			String topic = propertyConfigurer.getProperty(mbo.getTopic());

				if (StringUtils.isNotBlank(topic)) {
					topic = topic.trim();
				}
				else {
					log.error("topic和pic的属性配置错误，请参照其他消息配置！{PID:" + mbo.getPid() + ",TOPIC:" + mbo.getTopic() + "}");
				}

				TransactionProducer producer = null;

				if (nativeOns) {
					producer = new NativeTransOnsProductor(cacheService);
					producer.start();
					// producers.put(topic, producer);
				}
				else {
					String pid = propertyConfigurer.getProperty(mbo.getPid());
					if (StringUtils.isNotBlank(pid)) {
						pid = pid.trim();
					}
					else {
						log.error("topic和pic的属性配置错误，请参照其他消息配置！{PID:" + mbo.getPid() + ",TOPIC:" + mbo.getTopic() + "}");
					}
					Properties properties = new Properties();
					properties.put(PropertyKeyConst.ProducerId, pid); // 您在控制台创建的Producer ID

					// 如果鉴权信息存在，需要添加
					if (StringUtils.isNotBlank(accessKey)) {
						properties.put(PropertyKeyConst.AccessKey, accessKey);
					}
					// 如果鉴权信息存在，需要添加
					if (StringUtils.isNotBlank(secretKey)) {
						properties.put(PropertyKeyConst.SecretKey, secretKey);
					}

					// 如果nameServer 存在后面的那个无效
					if (StringUtils.isNotBlank(namesrvAddr)) {
						properties.put(PropertyKeyConst.NAMESRV_ADDR, namesrvAddr);
					}

					// 如果地址服务器存在，需要添加
					if (StringUtils.isNotBlank(oNSAddr)) {
						properties.put(PropertyKeyConst.ONSAddr, oNSAddr);
					}

					producer = ONSFactory.createTransactionProducer(properties, localTransactionChecker);
					producer.start();
					producerProperties.put(topic, properties);
				}
				producers.put(topic, producer);
			}
		}

	/** 获取生产者 <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @return
	 * @autho liuce
	 * @time 2016年9月11日 下午10:28:16 */
	public TransactionProducer getTransactionProducer(String topic) {
		TransactionProducer tp = producers.get(topic);
		return tp;
	}

	/** 获取生产者 <br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @return
	 * @autho liuce
	 * @time 2016年9月11日 下午10:28:16 */
	public synchronized TransactionProducer getSynTransactionProducer(String topic) {
		TransactionProducer tp = producers.get(topic);
		if (tp == null) {
			Properties properties = producerProperties.get(topic);
			tp = ONSFactory.createTransactionProducer(properties, localTransactionChecker);
			tp.start();
			producers.put(topic, tp);
		}
		return tp;
	}

}
