package com.ohaotian.base.mq.bo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


/** <br>
 * 标题: 外围接口基类 <br>
 * 描述: 指对外围系统的接口层和对页面的组合服务层<br>
 * 公司: www.chinaunicom.com<br>
 * 
 * @time 2016-7-4 下午1:06:53 */
public  class ReqInfceBaseBO implements Serializable {

	/**  */
	private static final long serialVersionUID = 318399374157993931L;

	/** STAFF_ID QRY_POOLINFO_REQ 1 String V20 操作员工号 */
	private String            staffId;
	/*** 原始操作员工 */
	private String            staffIdOld;
	/** PROVINCE_CODE QRY_POOLINFO_REQ 1 String F2 省分编码 */
	private String            provinceCode;
	/** CITY_CODE QRY_POOLINFO_REQ 1 String F4 地市编码 */
	private String            cityCode;
	/** DISTRICT_CODE QRY_POOLINFO_REQ 1 String V10 区县编码 */
	private String            districtCode;
	/** CHANNEL_ID QRY_POOLINFO_REQ 1 String V20 渠道编码 */
	private String            channelId;
	/** CHANNEL_TYPE QRY_POOLINFO_REQ 1 String F7 渠道类型 */
	private String            channelType;
	/** SYS_CODE QRY_POOLINFO_REQ 1 String F4 操作系统编码 */
	private String            sysCode;
	/** PARA QRY_POOLINFO_REQ * 保留字段 */
	private List<ParaBO>      para             = new ArrayList<ParaBO>();
	/** 部门编码 */
	private String            departId;
	/** 接口编码,区分不同的接口 */
	private String            interfaceCode;
	/** 调用方订单编号或流水号。 */
	private String            reqNo;

	/** 关键字，各个接口进入方法后自己赋值，最后在切面的时候统一处理 */
	private String            keyword;
	
	/** 日志使用：如果存在单号码，子类必须重写此方法，批量业务不用 */
	public String getSerialNumberBase() {
		return "";
	}

	public void setSerialNumberBase(String serialNumberBase) {

	}
	/** 日志使用：如果存在单卡号，子类必须重写此方法，批量业务不用 */
	public String getIccidBase() {
		return "";
	}

	public void setIccidBase(String iccidBase) {
		
	}

	/*	*//** 获取号码的方法 *//*
	public   String  getSerialNumberBase(){
		return null;
	}
	*//** 获取卡号的方法 *//*
	public   String  getIccidBase(){
		return null;
	}*/
	public String getStaffIdOld() {
		return staffIdOld;
	}

	public void setStaffIdOld(String staffIdOld) {
		this.staffIdOld = staffIdOld;
	}

	public String getDepartId() {
		return departId;
	}

	public void setDepartId(String departId) {
		this.departId = departId;
	}

	public String getReqNo() {
		return reqNo;
	}

	public void setReqNo(String reqNo) {
		this.reqNo = reqNo;
	}

	public String getStaffId() {
		return staffId;
	}

	public void setStaffId(String staffId) {
		this.staffId = staffId;
	}

	public String getProvinceCode() {
		return provinceCode;
	}

	public void setProvinceCode(String provinceCode) {
		this.provinceCode = provinceCode;
	}

	public String getCityCode() {
		return cityCode;
	}

	public void setCityCode(String cityCode) {
		this.cityCode = cityCode;
	}

	public String getDistrictCode() {
		return districtCode;
	}

	public void setDistrictCode(String districtCode) {
		this.districtCode = districtCode;
	}

	public String getChannelId() {
		return channelId;
	}

	public void setChannelId(String channelId) {
		this.channelId = channelId;
	}

	public String getChannelType() {
		return channelType;
	}

	public void setChannelType(String channelType) {
		this.channelType = channelType;
	}

	public String getSysCode() {
		return sysCode;
	}

	public void setSysCode(String sysCode) {
		this.sysCode = sysCode;
	}

	public List<ParaBO> getPara() {
		return para;
	}

	public void setPara(List<ParaBO> para) {
		this.para = para;
	}

	/** 返回 接口编码区分不同的接口
	 * 
	 * @return 接口编码区分不同的接口 */
	public String getInterfaceCode() {
		return interfaceCode;
	}

	/** 设置 接口编码区分不同的接口
	 * 
	 * @param interfaceCode
	 *        接口编码区分不同的接口 */
	public void setInterfaceCode(String interfaceCode) {
		this.interfaceCode = interfaceCode;
	}

	public String getKeyword() {
		return keyword;
	}

	public void setKeyword(String keyword) {
		this.keyword = keyword;
	}

	@Override
	public String toString() {
		return "ReqInfceBaseBO [staffId=" + staffId + ", staffIdOld=" + staffIdOld + ", provinceCode=" + provinceCode + ", cityCode=" + cityCode + ", districtCode=" + districtCode + ", channelId="
		        + channelId + ", channelType=" + channelType + ", sysCode=" + sysCode + ", para=" + para + ", departId=" + departId + ", interfaceCode=" + interfaceCode + ", reqNo=" + reqNo
		        + ", keyword=" + keyword + "]";
	}

}
