package com.ohaotian.base.mq.produce;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionExecuter;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.ohaotian.base.cache.CacheService;
import com.ohaotian.base.mq.bo.MqConstants;
import com.ohaotian.base.mq.MqMessageListener;
import com.ohaotian.base.mq.MqTranProducerPool;
import com.ohaotian.base.mq.exception.ResourceException;
import com.ohaotian.base.mq.util.ClassUtils;
import com.ohaotian.base.mq.util.LogUtils;
import com.ohaotian.base.mq.util.ReflectionUtils;
import com.ohaotian.base.util.SerializeUtils;
import com.taobao.eagleeye.EagleEye;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/** <br>
 * 标题: <br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * 
 * @autho liuce
 * @time 2016年8月30日 下午9:47:50 */
public class MqTransactionProducer {

	private final static Logger                          log            = LoggerFactory.getLogger(MqTransactionProducer.class);

	private final static boolean                         isDebugEnabled = log.isDebugEnabled();

	/** 本地事务执行器集合 */
	private static Map<Object, LocalTransactionExecuter> execters       = new HashMap<Object, LocalTransactionExecuter>();

	/** 本地事务接口方法集合 */
	private static Map<String, Method>                   localMethods   = new HashMap<String, Method>();

	/** 生产者池 */
	private static MqTranProducerPool                    mqTranProducerPool;

	/** 缓存service */
	private static CacheService cacheService;

	/** 设置 生产者池
	 * 
	 * @param mqTranProducerPool
	 *        生产者池 */
	public void setMqTranProducerPool(MqTranProducerPool mqTranProducerPool) {
		MqTransactionProducer.mqTranProducerPool = mqTranProducerPool;
	}

	/** 设置 缓存service
	 * 
	 * @param cacheService
	 *        缓存service */
	public void setCacheService(CacheService cacheService) {
		MqTransactionProducer.cacheService = cacheService;
	}

	/** 发送消息<br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param mQLocalExecuterService
	 *        业务处理实例
	 * @param method
	 *        需要执行的方法
	 * @param arg
	 *        需要执行的方法的入餐
	 * @param topic
	 *        消息主题
	 * @param tag
	 *        消息tag
	 * @param body
	 *        消息内容
	 * @autho liuce
	 * @time 2016年9月1日 下午11:06:39 */
	public static void sendMsg(final Object mQLocalExecuterService, String method, Object arg, String topic, String tag, Object body) {

		topic = mqTranProducerPool.getPropertyConfigurer().getProperty(topic);
		Message msg = new Message(topic, tag, SerializeUtils.serialize(body));
		// 添加TraceId
		String traceId = getTraceId();
		//这里为了解决消费者里再发消息获取不到traceID的问题用了本地线程变量
		if(StringUtils.isBlank(traceId)){
			traceId = MqMessageListener.traceIds.get();
		}
		
		msg.putUserProperties("TraceId", traceId);
		// 得到本地事务执行器
		LocalTransactionExecuter localTransactionExecuter = getLocalTranExecuter(mQLocalExecuterService, method, arg);

		// 获取生产者
		TransactionProducer transactionProducer = mqTranProducerPool.getTransactionProducer(topic);

		if (transactionProducer == null) {
			transactionProducer = mqTranProducerPool.getSynTransactionProducer(topic);
		}

		// log.debug("transactionProducer=" + transactionProducer);
		ResourceException.MQ_THREAD_EXCEPTION.set(null);
		// long startDate = 0;
		// 获取目标对象对应的类名
		String className = null;
		// 先判断这个类是否是代理类，如果是的话，则或者代理的真正的类
		try {
			Object obj = ClassUtils.getTarget(mQLocalExecuterService);
			className = obj.getClass().getName();
		} catch (Exception e) {
			log.error("获取生产者真实类出错，请检测代码",e);
		}
		
		
		try {
			// startDate = System.currentTimeMillis();
			// 发送事务消息
			SendResult srt = transactionProducer.send(msg, localTransactionExecuter, arg);



			// 打印标准日志
			LogUtils.printMQProducerLog(className, method, msg, body);

			if (!mqTranProducerPool.isNativeOns()) {
				// long endDate = System.currentTimeMillis();
				cacheService.put(msg.getMsgID(), MqConstants.PRODUCT_SEND_STATUS_SUCCESS, MqConstants.MQ_TRAN_CHECK_EXPIRE);
				if (isDebugEnabled) {
					log.debug("send tran msg msgId={" + msg.getMsgID() + "}  topic=" + topic + " tag=" + tag + "  key={" + msg.getKey() + "}  body={" + body + "}  SendResult={" + srt + "}");
				}
			}
		}
		catch (ResourceException e) {
			if (!mqTranProducerPool.isNativeOns()) {
				cacheService.put(msg.getMsgID(), MqConstants.PRODUCT_SEND_STATUS_FAILURE, MqConstants.MQ_TRAN_CHECK_EXPIRE);
			}
			ResourceException re = ResourceException.MQ_THREAD_EXCEPTION.get();
			log.error("send tran msg exception msg={" + msg + "}  body={" + body + "} ", re);

			if (re != null) {
				throw re;
			}
			throw e;
		}
		catch (Throwable e) {
			
			if (!mqTranProducerPool.isNativeOns()) {
				if (msg.getMsgID() != null) {
					cacheService.put(msg.getMsgID(), MqConstants.PRODUCT_SEND_STATUS_FAILURE, MqConstants.MQ_TRAN_CHECK_EXPIRE);
				}
			}

			ResourceException re = ResourceException.MQ_THREAD_EXCEPTION.get();
			log.error("send tran msg exception msg={" + msg + "}  body={" + body + "} ", re);
			if (re != null) {
				// 打印标准错误日志
				LogUtils.printMQErrorLog(className, method, msg, body, re);
				throw re;
			}
			// 打印标准错误日志
			LogUtils.printMQErrorLog(className, method, msg, body, e);
			throw e;
		}

	}

	/** 发送消息<br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param mQLocalExecuterService
	 *        业务处理实例
	 * @param method
	 *        需要执行的方法
	 * @param arg
	 *        需要执行的方法的入餐
	 * @param topic
	 *        消息主题
	 * @param tag
	 *        消息tag
	 * @param body
	 *        消息内容
	 * @autho liuce
	 * @time 2016年9月1日 下午11:06:39 */
	public static void sendMsg(final Object mQLocalExecuterService, String method, Object arg, String topic, String tag, String key, Object body) {

		topic = mqTranProducerPool.getPropertyConfigurer().getProperty(topic);
		Message msg = new Message(topic, tag, key, SerializeUtils.serialize(body));
		// 添加TraceId
		String traceId = getTraceId();
		//这里为了解决消费者里再发消息获取不到traceID的问题用了本地线程变量
		if(StringUtils.isBlank(traceId)){
			traceId = MqMessageListener.traceIds.get();
		}
		
		msg.putUserProperties("TraceId", traceId);
		// 得到本地事务执行器
		LocalTransactionExecuter localTransactionExecuter = getLocalTranExecuter(mQLocalExecuterService, method, arg);

		// 获取生产者
		TransactionProducer transactionProducer = mqTranProducerPool.getTransactionProducer(topic);

		if (transactionProducer == null) {
			transactionProducer = mqTranProducerPool.getSynTransactionProducer(topic);
		}
		// log.debug("transactionProducer=" + transactionProducer);
		ResourceException.MQ_THREAD_EXCEPTION.set(null);
		// long startDate = 0;
		// 获取目标对象对应的类名
		String className = null;
		// 先判断这个类是否是代理类，如果是的话，则或者代理的真正的类
		try {
			Object obj = ClassUtils.getTarget(mQLocalExecuterService);
			className = obj.getClass().getName();
		} catch (Exception e) {
			log.error("获取生产者真实类出错，请检测代码",e);
		}
		
		try {
			// startDate = System.currentTimeMillis();
			// 发送事务消息
			SendResult srt = transactionProducer.send(msg, localTransactionExecuter, arg);

			// 打印标准日志
			LogUtils.printMQProducerLog(className, method, msg, body);

			if (!mqTranProducerPool.isNativeOns()) {
				// long endDate = System.currentTimeMillis();
				cacheService.put(msg.getMsgID(), MqConstants.PRODUCT_SEND_STATUS_SUCCESS, MqConstants.MQ_TRAN_CHECK_EXPIRE);
				if (isDebugEnabled) {
					log.debug("send tran msg msgId={" + msg.getMsgID() + "}  topic=" + topic + " tag=" + tag + "  key={" + msg.getKey() + "}  body={" + body + "}  SendResult={" + srt + "}");
				}
			}
		}
		catch (ResourceException e) {
			if (!mqTranProducerPool.isNativeOns()) {
				cacheService.put(msg.getMsgID(), MqConstants.PRODUCT_SEND_STATUS_FAILURE, MqConstants.MQ_TRAN_CHECK_EXPIRE);
			}
			ResourceException re = ResourceException.MQ_THREAD_EXCEPTION.get();
			log.error("send tran msg exception msg={" + msg + "}  body={" + body + "} ", re);
			if (re != null) {
				throw re;
			}
			throw e;
		}
		catch (Throwable e) {
			if (!mqTranProducerPool.isNativeOns()) {
				if (msg.getMsgID() != null) {
					cacheService.put(msg.getMsgID(), MqConstants.PRODUCT_SEND_STATUS_FAILURE, MqConstants.MQ_TRAN_CHECK_EXPIRE);
				}
			}
			ResourceException re = ResourceException.MQ_THREAD_EXCEPTION.get();
			log.error("send tran msg exception msg={" + msg + "}  body={" + body + "} ", re);
			if (re != null) {
				// 打印标准错误日志
				LogUtils.printMQErrorLog(className, method, msg, body, re);
				throw re;
			}
			// 打印标准错误日志
			LogUtils.printMQErrorLog(className, method, msg, body, e);
			throw e;
		}

	}

	/** 根据service获取本地事务执行器<br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param mQLocalExecuterService
	 * @return
	 * @autho liuce
	 * @time 2016年8月31日 下午9:15:39 */
	private static LocalTransactionExecuter getLocalTranExecuter(final Object mQLocalExecuterService, final String methodName, final Object args) {

		AbstractLocalTransactionExecuter localTransactionExecuter = (AbstractLocalTransactionExecuter) execters.get(mQLocalExecuterService + methodName);

		if (localTransactionExecuter == null) {
			localTransactionExecuter = new AbstractLocalTransactionExecuter(mQLocalExecuterService, methodName);
			execters.put(mQLocalExecuterService + methodName, localTransactionExecuter);
		}
		localTransactionExecuter.setArgs(args);
		return localTransactionExecuter;
	}

	private static class AbstractLocalTransactionExecuter implements LocalTransactionExecuter {

		private ThreadLocal<Object> args = new ThreadLocal<Object>();
		private final Object        mQLocalExecuterService;
		private final String        methodName;

		public AbstractLocalTransactionExecuter(Object mQLocalExecuterService, String methodName) {
			this.mQLocalExecuterService = mQLocalExecuterService;
			this.methodName = methodName;
		}

		public void setArgs(Object args) {
			this.args.set(args);
		}

		@Override
		public TransactionStatus execute(Message msg, Object arg) {
			try {
				invokeMethod(mQLocalExecuterService, methodName, args.get());
			}
			catch (Exception e) {
				log.error("msgid:[" + msg.getMsgID() + "]本地事务异常，默认回滚并回滚消息", e);
				// 回滚事务
				return TransactionStatus.RollbackTransaction;
			}
			finally {
				args.set(null);
			}
			// 提交成功消息
			return TransactionStatus.CommitTransaction;
		}
	}

	/** 回调本地事务<br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param mQLocalExecuterService
	 * @param methodName
	 * @param args
	 * @throws Exception
	 * @autho liuce
	 * @time 2016年9月1日 下午5:00:09 */
	private static void invokeMethod(final Object mQLocalExecuterService, String methodName, Object args) throws Exception {
		
		// 需要执行的方法
		Method method = localMethods.get(mQLocalExecuterService + methodName);
		if (method == null) {

			method = ReflectionUtils.getDeclaredMethod(mQLocalExecuterService, methodName);
			if (method != null) {
				localMethods.put(mQLocalExecuterService + methodName, method);
			}

			// Class<?> c = mQLocalExecuterService.getClass();
			// for (Method m : c.getDeclaredMethods()) {
			// if (methodName.equals(m.getName())) {
			// localMethods.put(mQLocalExecuterService + methodName, m);
			// method = m;
			// break;
			// }
			//
			// }
		}

		log.debug("method=" + method);
		method.invoke(mQLocalExecuterService, args);

	}
	private static final String getTraceId() {
		String traceId = EagleEye.getTraceId();
		if (StringUtils.isBlank(traceId)) {
			traceId = "";
		}
		return traceId;
	}

}
