package com.ohaotian.base.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.ohaotian.base.constant.SessionConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * Caffeine Config
 *
 * @author liubinqi(liubq@tydic.com)
 */
@Configuration
public class CacheConfig {

    private final static Logger log = LoggerFactory.getLogger(CacheConfig.class);

    private static long size = SessionConstant.caffeineSize;
    private static long expire = SessionConstant.defaultMaxInactiveIntervalCaffeine;


    @Resource
    private CacheService redisCache;


    /**
     * 初始化Caffeine
     */
    @Bean
    public CaffeineCache init() {
        CaffeineCache caffeineCache = buildCache();
        CacheTemplate cacheTemplate = CacheTemplate.getIstance();
        cacheTemplate.init(caffeineCache, redisCache);
        return caffeineCache;
    }

    /**
     * 返回对 Caffeine cache 的 封装
     *
     * @return CaffeineCache
     */
    public CaffeineCache buildCache() {
        com.github.benmanes.caffeine.cache.Cache<String, Object> loadingCache = Caffeine.newBuilder()
                .maximumSize(size)
                .expireAfterWrite(expire, TimeUnit.SECONDS)
                .removalListener((String key, Object value, RemovalCause cause) -> {
                    if (cause != RemovalCause.EXPLICIT && cause != RemovalCause.REPLACED) {
                        log.info("removal listerner called with key [%s], cause [%s], evicted [%S] size [%s], expire [%s]\n",
                                key, cause.toString(), cause.wasEvicted(),size, expire);
                    }
                })
                .build();

        return new CaffeineCache(loadingCache, size, expire);

    }

}