package com.ohaotian.base.session;

import com.ohaotian.base.cache.CacheTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.session.SessionRepository;

public class CacheSessionRepository implements SessionRepository<CacheSession> {


    private final static Logger logger = LoggerFactory.getLogger(CacheSessionRepository.class);



    private CacheTemplate cacheTemplate = CacheTemplate.getIstance();

    private final static String REGION = "SESSIONID";

    @Override
    public CacheSession createSession() {
        CacheSession session = new CacheSession();
        return session;
    }

    @Override
    public void save(CacheSession session) {
        session.getMaxInactiveIntervalInSeconds();
        if (session == null)
            return;
        if (session.isNew()) {
            session.setNew(false);
            cacheTemplate.set(getSessionId(session.getId()), session);
        }
    }

    @Override
    public CacheSession getSession(String id) {
        Object o = cacheTemplate.get(getSessionId(id));
        if (o == null)
            return null;
        CacheSession session = (CacheSession) o;
        session.setLastAccessedTime(System.currentTimeMillis());
        logger.info(o.toString());
        logger.info(session.getCreationTime() + " " + session.getLastAccessedTime() + " " + session.getCreationTime());
        return session;
    }

    @Override
    public void delete(String id) {
        CacheSession session = getSession(id);
        if (session == null)
            return;
        cacheTemplate.del(getSessionId(id));
    }

    private String getSessionId(String id){
        return REGION+":"+id;
    }

}
