/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.cache;

import com.ohaotian.base.cache.CacheService;
import com.ohaotian.base.cache.CaffeineCache;
import com.ohaotian.base.cache.RedisPubSubClusterPolicy;
import com.ohaotian.base.constant.SessionConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class CacheTemplate {
    private static final Logger log = LoggerFactory.getLogger(CacheTemplate.class);
    private static volatile CacheTemplate instance;
    private static CaffeineCache caffeineCache;
    private CacheService redisCache;
    private static final RedisPubSubClusterPolicy policy;

    private CacheTemplate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheTemplate getIstance() {
        if (instance != null) return instance;
        Class<CacheTemplate> clazz = CacheTemplate.class;
        synchronized (CacheTemplate.class) {
            if (instance != null) return instance;
            instance = new CacheTemplate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected void init(CaffeineCache caffeineCache, CacheService redisCache) {
        CacheTemplate.caffeineCache = caffeineCache;
        this.redisCache = redisCache;
        policy.connect(redisCache.getJedisPool());
    }

    public void set(String key, Object value) {
        try {
            caffeineCache.put(key, value);
            this.redisCache.put(key, value, SessionConstant.defaultMaxInactiveIntervalReids.intValue());
        }
        finally {
            policy.sendClearCmd(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Object level1Value = caffeineCache.get(key);
        if (level1Value != null) {
            return level1Value;
        }
        Object level2Value = this.redisCache.get(key);
        if (level2Value != null) {
            caffeineCache.put(key, level2Value);
            try (Jedis jedis = null;){
                jedis = this.redisCache.getJedisPool().getResource();
                jedis.expire(key, 600);
            }
            return level2Value;
        }
        return null;
    }

    public void del(String key) {
        caffeineCache.evict(key);
        this.redisCache.delete(key);
        policy.sendClearCmd(key);
    }

    public void evict(String key) {
        caffeineCache.evict(key);
    }

    static {
        policy = new RedisPubSubClusterPolicy();
    }
}

