/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.cache;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class CaffeineCache {
    private Cache<String, Object> cache;
    private long size;
    private long expire;

    public CaffeineCache(Cache<String, Object> cache, long size, long expire) {
        this.cache = cache;
        this.size = size;
        this.expire = expire;
    }

    public long ttl() {
        return this.expire;
    }

    public long size() {
        return this.size;
    }

    public Object get(String key) {
        return this.cache.getIfPresent((Object)key);
    }

    public Map<String, Object> get(Collection<String> keys) {
        return this.cache.getAllPresent(keys);
    }

    public void put(String key, Object value) {
        this.cache.put((Object)key, value);
    }

    public void put(Map<String, Object> elements) {
        this.cache.putAll(elements);
    }

    public Collection<String> keys() {
        return this.cache.asMap().keySet();
    }

    public void evict(String ... keys) {
        this.cache.invalidateAll(Arrays.asList(keys));
    }

    public void clear() {
        this.cache.invalidateAll();
    }
}

