/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.session;

import com.ohaotian.base.cache.CacheTemplate;
import com.ohaotian.base.session.CacheSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.session.SessionRepository;

public class CacheSessionRepository
implements SessionRepository<CacheSession> {
    private static final Logger logger = LoggerFactory.getLogger(CacheSessionRepository.class);
    private CacheTemplate cacheTemplate = CacheTemplate.getIstance();
    private static final String REGION = "SESSIONID";

    public CacheSession createSession() {
        CacheSession session = new CacheSession();
        return session;
    }

    public void save(CacheSession session) {
        session.getMaxInactiveIntervalInSeconds();
        if (session == null) {
            return;
        }
        if (session.isNew()) {
            session.setNew(false);
            this.cacheTemplate.set(this.getSessionId(session.getId()), session);
        }
    }

    public CacheSession getSession(String id) {
        Object o = this.cacheTemplate.get(this.getSessionId(id));
        if (o == null) {
            return null;
        }
        CacheSession session = (CacheSession)o;
        session.setLastAccessedTime(System.currentTimeMillis());
        logger.info(o.toString());
        logger.info(session.getCreationTime() + " " + session.getLastAccessedTime() + " " + session.getCreationTime());
        return session;
    }

    public void delete(String id) {
        CacheSession session = this.getSession(id);
        if (session == null) {
            return;
        }
        this.cacheTemplate.del(this.getSessionId(id));
    }

    private String getSessionId(String id) {
        return "SESSIONID:" + id;
    }
}

