/*
 * Decompiled with CFR 0.152.
 */
package com.haotian.remote;

import com.haotian.remote.AnnotationUtil;
import com.haotian.remote.ProxyProvider;
import com.haotian.remote.RemoteConsumer;
import com.haotian.remote.RemoteProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class ProxyXmlWebApplicationContext
extends XmlWebApplicationContext {
    private static final Logger logger = Logger.getLogger(ProxyXmlWebApplicationContext.class.getName());
    private static final PathMatchingResourcePatternResolver PMRPR = new PathMatchingResourcePatternResolver(AnnotationUtil.class.getClassLoader());
    private static final Properties CONTEXT_PROPS = new Properties();
    private static final Map<Class<?>, Set<String>> PROXY_BEAN_MAPPINGS = new HashMap();

    private static final void addProxyBean(Class<?> beanClass, String beanName) {
        Set<String> beanNameSet;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("loaded proxy bean[beanName:" + beanName + ", class:" + beanClass.getName() + "].");
        }
        if ((beanNameSet = PROXY_BEAN_MAPPINGS.get(beanClass)) == null) {
            beanNameSet = new HashSet<String>();
            PROXY_BEAN_MAPPINGS.put(beanClass, beanNameSet);
        }
        if (beanNameSet.contains(beanName)) {
            throw new RuntimeException("[id:" + beanName + ", class:" + beanClass + "] repeated!!!");
        }
        beanNameSet.add(beanName);
    }

    public static final Set<String> getBeanNames(Class<?> beanClass) {
        return PROXY_BEAN_MAPPINGS.get(beanClass);
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws IOException {
        String[] configLocations;
        super.loadBeanDefinitions(reader);
        for (String configLoaction : configLocations = super.getConfigLocations()) {
            Resource[] locations = PMRPR.getResources(configLoaction);
            if (locations == null) continue;
            SAXReader saxReader = new SAXReader();
            for (Resource location : locations) {
                this.parseAndLoadResource(saxReader, location);
            }
        }
        List<RemoteProvider> providerList = ProxyXmlWebApplicationContext.extractProviderList();
        List<RemoteConsumer> consumerList = ProxyXmlWebApplicationContext.extractConsumerList();
        String classpath = Thread.currentThread().getContextClassLoader().getResource(File.separator).getPath();
        if (!classpath.endsWith(File.separator)) {
            classpath = classpath + File.separator;
        }
        String remoteFileName = "proxy-remote-provider.xml";
        File remoteFile = new File(classpath + remoteFileName);
        remoteFile.deleteOnExit();
        remoteFile.createNewFile();
        FileOutputStream foutput = new FileOutputStream(remoteFile);
        foutput.write(this.generateProviderBeans(providerList));
        foutput.close();
        reader.loadBeanDefinitions("classpath:" + remoteFileName);
        remoteFileName = "proxy-remote-consumer.xml";
        remoteFile = new File(classpath + remoteFileName);
        remoteFile.deleteOnExit();
        remoteFile.createNewFile();
        foutput = new FileOutputStream(remoteFile);
        foutput.write(ProxyXmlWebApplicationContext.genenrateConsumerBeans(consumerList, providerList));
        foutput.close();
        reader.loadBeanDefinitions("classpath:" + remoteFileName);
    }

    private static String getRemoteScanPackageName() {
        String scanPackage = CONTEXT_PROPS.getProperty("remote.scan.package");
        String scanTip = "[remote.scan.package] not configured in properties file. scan all package for remote invoke";
        if (scanPackage != null && !"".equals(scanPackage)) {
            scanTip = "scan package[" + scanPackage + "] for remote invoke";
        }
        logger.info(scanTip);
        return scanPackage;
    }

    public static List<RemoteProvider> extractProviderList() {
        List<RemoteProvider> providerList;
        try {
            providerList = AnnotationUtil.extractProxyProviders(ProxyXmlWebApplicationContext.getRemoteScanPackageName());
        }
        catch (Exception e) {
            throw new RuntimeException("extract proxyprovider error", e);
        }
        return providerList;
    }

    public static List<RemoteConsumer> extractConsumerList() {
        List<RemoteConsumer> consumerList;
        try {
            consumerList = AnnotationUtil.extractProxyConsumers(ProxyXmlWebApplicationContext.getRemoteScanPackageName());
        }
        catch (Exception e) {
            throw new RuntimeException("extract proxyconsumer error", e);
        }
        return consumerList;
    }

    private void loadedProxyBeansAndInitContextProps(Resource contextLocation, Element rootElement, SAXReader saxReader) throws ClassNotFoundException, IOException {
        List beanList = rootElement.elements("bean");
        for (Element bean : beanList) {
            Class<?> beanClass = Class.forName(bean.attributeValue("class"));
            if (beanClass.getAnnotation(ProxyProvider.class) != null) {
                String beanName = bean.attributeValue("id");
                if (beanName == null) {
                    beanName = bean.attributeValue("name");
                }
                if (beanName == null) {
                    throw new RuntimeException("beanName required for class[" + beanClass.getName() + "] in file[" + contextLocation.getFilename() + "]");
                }
                ProxyXmlWebApplicationContext.addProxyBean(beanClass, beanName);
                continue;
            }
            if (!PropertiesFactoryBean.class.isAssignableFrom(beanClass)) continue;
            ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("classpath*:**/" + contextLocation.getFilename());
            String beanName = bean.attributeValue("id");
            if (beanName == null) {
                beanName = bean.attributeValue("name");
            }
            if (beanName == null) continue;
            try {
                Properties props = (Properties)applicationContext.getBean(beanName, Properties.class);
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)CONTEXT_PROPS);
            }
            catch (Exception e) {
                logger.info("load properties[" + contextLocation.getFilename() + "] error:" + e.getMessage());
            }
        }
        List importList = rootElement.elements("import");
        for (Element importResource : importList) {
            Resource[] locations;
            for (Resource location : locations = PMRPR.getResources(importResource.attributeValue("resource"))) {
                this.parseAndLoadResource(saxReader, location);
            }
        }
    }

    private void parseAndLoadResource(SAXReader saxReader, Resource location) throws IOException {
        InputStream locationInput = location.getInputStream();
        try {
            this.loadedProxyBeansAndInitContextProps(location, saxReader.read(locationInput).getRootElement(), saxReader);
        }
        catch (Exception e) {
            logger.info("parse bean error:" + e.getMessage() + " for [" + location.getFilename() + "]");
        }
        locationInput.close();
    }

    private static String getRemoteStrategy() {
        String remoteStrategy = CONTEXT_PROPS.getProperty("remote.strategy");
        if (remoteStrategy == null) {
            remoteStrategy = "HSF";
        }
        return remoteStrategy;
    }

    public static byte[] genenrateConsumerBeans(List<RemoteConsumer> consumers, List<RemoteProvider> providerList) {
        byte[] springBeans;
        byte[] byArray = springBeans = ProxyXmlWebApplicationContext.getRemoteStrategy().equals("HSF") ? ProxyXmlWebApplicationContext.generateHsfConsumerBeans(consumers, providerList) : ProxyXmlWebApplicationContext.generateHsfConsumerBeans(consumers, providerList);
        if (logger.isLoggable(Level.INFO)) {
            logger.info(new String(springBeans));
        }
        return springBeans;
    }

    private byte[] generateProviderBeans(List<RemoteProvider> providers) {
        byte[] springBeans;
        byte[] byArray = springBeans = ProxyXmlWebApplicationContext.getRemoteStrategy().equals("HSF") ? this.generateHsfProviderBeans(providers) : this.generateHsfProviderBeans(providers);
        if (logger.isLoggable(Level.INFO)) {
            logger.info(new String(springBeans));
        }
        return springBeans;
    }

    private static String getRealValue(String value) {
        if (value == null || !value.startsWith("${") || !value.endsWith("}")) {
            return value;
        }
        String key = value.substring(2, value.length() - 1);
        String parsedValue = CONTEXT_PROPS.getProperty(key);
        if (parsedValue == null || "".equals(parsedValue)) {
            throw new RuntimeException("extract [" + value + "] value is empty.");
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("extract [" + value + "] value is [" + parsedValue + "].");
        }
        return parsedValue;
    }

    private static byte[] generateHsfConsumerBeans(List<RemoteConsumer> consumers, List<RemoteProvider> providerList) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(output);
        HashMap<String, String> providerInterfaces = new HashMap<String, String>();
        for (RemoteProvider provider : providerList) {
            String providerVersion = ProxyXmlWebApplicationContext.getRealValue(provider.getVersion());
            String providerGroup = ProxyXmlWebApplicationContext.getRealValue(provider.getGroup());
            providerInterfaces.put(provider.getInterface() + ":" + providerVersion + ":" + providerGroup, provider.getRef());
        }
        print.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        print.println("<beans xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        print.println("xmlns:hsf=\"http://www.taobao.com/hsf\"");
        print.println("xmlns=\"http://www.springframework.org/schema/beans\"");
        print.println("xsi:schemaLocation=\"http://www.springframework.org/schema/beans");
        print.println("http://www.springframework.org/schema/beans/spring-beans-2.5.xsd");
        print.println("http://www.taobao.com/hsf");
        print.println("http://www.taobao.com/hsf/hsf.xsd\">");
        for (RemoteConsumer consumer : consumers) {
            String consumerVersion = ProxyXmlWebApplicationContext.getRealValue(consumer.getVersion());
            String consumerGroup = ProxyXmlWebApplicationContext.getRealValue(consumer.getGroup());
            if (providerInterfaces.containsKey(consumer.getInterface() + ":" + consumerVersion + ":" + consumerGroup)) {
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.info("consumer[" + consumer.getInterface() + ":" + consumerVersion + ":" + consumerGroup + "]'s provider exists; Do not publish consumer.");
                continue;
            }
            String beanId = ProxyXmlWebApplicationContext.getRealValue(consumer.getBeanId());
            if (beanId == null || "".equals(beanId)) {
                throw new RuntimeException("consumerId required[" + consumer.getInterface());
            }
            if (providerInterfaces.containsValue(beanId)) {
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.info("consumer[" + beanId + ":" + consumer.getInterface() + ":" + consumer.getVersion() + ":" + consumer.getGroup() + "]'s conflict.");
                continue;
            }
            print.print("<hsf:consumer");
            print.print(" id=\"");
            print.print(beanId);
            print.print("\"");
            print.print(" interface=\"");
            print.print(ProxyXmlWebApplicationContext.getRealValue(consumer.getInterface()));
            print.print("\"");
            print.print(" version=\"");
            print.print(ProxyXmlWebApplicationContext.getRealValue(consumer.getVersion()));
            print.print("\"");
            if (consumer.getGroup() != null && !"".equals(consumer.getGroup())) {
                print.print(" group=\"");
                print.print(ProxyXmlWebApplicationContext.getRealValue(consumer.getGroup()));
                print.print("\"");
            }
            if (consumer.getTarget() != null && !"".equals(consumer.getTarget())) {
                print.print(" target=\"");
                print.print(ProxyXmlWebApplicationContext.getRealValue(consumer.getTarget()));
                print.print("\"");
            }
            if (consumer.getClientTimeout() != 0L) {
                print.print(" clientTimeout=\"");
                print.print(consumer.getClientTimeout());
                print.print("\"");
            }
            if (consumer.getConnectionNum() != 0) {
                print.print(" connectionNum=\"");
                print.print(consumer.getConnectionNum());
                print.print("\"");
            }
            print.println("></hsf:consumer>");
        }
        print.println("</beans>");
        print.flush();
        print.close();
        return output.toByteArray();
    }

    private byte[] generateHsfProviderBeans(List<RemoteProvider> providers) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(output);
        print.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        print.println("<beans xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        print.println("xmlns:hsf=\"http://www.taobao.com/hsf\"");
        print.println("xmlns=\"http://www.springframework.org/schema/beans\"");
        print.println("xsi:schemaLocation=\"http://www.springframework.org/schema/beans");
        print.println("http://www.springframework.org/schema/beans/spring-beans-2.5.xsd");
        print.println("http://www.taobao.com/hsf");
        print.println("http://www.taobao.com/hsf/hsf.xsd\">");
        for (RemoteProvider provider : providers) {
            String providerRef = ProxyXmlWebApplicationContext.getRealValue(provider.getRef());
            if (providerRef == null || "".equals(providerRef)) {
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.info("Provider [" + ProxyXmlWebApplicationContext.getRealValue(provider.getInterface()) + ":" + ProxyXmlWebApplicationContext.getRealValue(provider.getVersion()) + "] ref not exists.");
                continue;
            }
            print.print("<hsf:provider");
            print.print(" id=\"");
            print.print(providerRef + "-" + ProxyXmlWebApplicationContext.getRealValue(provider.getVersion()) + "-provider");
            print.print("\"");
            print.print(" interface=\"");
            print.print(ProxyXmlWebApplicationContext.getRealValue(provider.getInterface()));
            print.print("\"");
            print.print(" ref=\"");
            print.print(ProxyXmlWebApplicationContext.getRealValue(provider.getRef()));
            print.print("\"");
            print.print(" version=\"");
            print.print(ProxyXmlWebApplicationContext.getRealValue(provider.getVersion()));
            print.print("\"");
            if (provider.getGroup() != null && !"".equals(provider.getGroup())) {
                print.print(" group=\"");
                print.print(ProxyXmlWebApplicationContext.getRealValue(provider.getGroup()));
                print.print("\"");
            }
            if (provider.getClientTimeout() != 0L) {
                print.print(" clientTimeout=\"");
                print.print(provider.getClientTimeout());
                print.print("\"");
            }
            if (provider.getCorePoolSize() != 0) {
                print.print(" corePoolSize=\"");
                print.print(provider.getCorePoolSize());
                print.print("\"");
            }
            if (provider.getMaxPoolSize() != 0) {
                print.print(" maxPoolSize=\"");
                print.print(provider.getMaxPoolSize());
                print.print("\"");
            }
            if (provider.getSerializeType() != null && !"".equals(provider.getSerializeType())) {
                print.print(" serializeType=\"");
                print.print(ProxyXmlWebApplicationContext.getRealValue(provider.getSerializeType()));
                print.print("\"");
            }
            print.println("></hsf:provider>");
        }
        print.println("</beans>");
        print.flush();
        print.close();
        return output.toByteArray();
    }
}

