/*
 * Decompiled with CFR 0.152.
 */
package com.haotian.remote;

import com.haotian.remote.ProxyProvider;
import com.haotian.remote.ProxyXmlWebApplicationContext;
import com.haotian.remote.RemoteFactoryBean;
import com.haotian.remote.RemoteHandler;
import java.util.Set;
import java.util.logging.Logger;

public class RemoteProvider {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private String version;
    private long clientTimeout;
    private String serializeType;
    private int corePoolSize;
    private int maxPoolSize;
    private String intface;
    private String group;
    private String ref;
    private RemoteFactoryBean remoteFactoryBean;

    protected RemoteProvider(Class<?> providerClazz) {
        ProxyProvider proxyProvider = providerClazz.getAnnotation(ProxyProvider.class);
        this.version = proxyProvider.version();
        this.clientTimeout = proxyProvider.clientTimeout();
        this.serializeType = proxyProvider.serializeType();
        this.corePoolSize = proxyProvider.corePoolSize();
        this.maxPoolSize = proxyProvider.maxPoolSize();
        this.intface = providerClazz.getInterfaces()[0].getName();
        this.group = proxyProvider.group();
        RemoteHandler remoteHandler = providerClazz.getAnnotation(RemoteHandler.class);
        Set<String> refSet = ProxyXmlWebApplicationContext.getBeanNames(providerClazz);
        if (refSet == null && remoteHandler == null) {
            return;
        }
        if (refSet != null) {
            if (refSet.size() > 1) {
                throw new RuntimeException("find more providerClass[" + providerClazz.getName() + "] for remote provider.");
            }
            if (!refSet.isEmpty()) {
                this.ref = refSet.iterator().next();
            }
        }
        this.logger.info("Class[" + providerClazz.getName() + "] remote handler[" + (remoteHandler == null ? "none" : remoteHandler.value().getName()) + "]");
        if (remoteHandler != null) {
            try {
                this.remoteFactoryBean = remoteHandler.value().newInstance();
                this.remoteFactoryBean.setObjectType(providerClazz);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Init remote factory bean error", e);
            }
        }
    }

    public RemoteFactoryBean getRemoteFactoryBean() {
        return this.remoteFactoryBean;
    }

    public String getRef() {
        return this.ref;
    }

    public String getVersion() {
        return this.version;
    }

    public long getClientTimeout() {
        return this.clientTimeout;
    }

    public String getSerializeType() {
        return this.serializeType;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public String getInterface() {
        return this.intface;
    }

    public String getGroup() {
        return this.group;
    }

    public String toString() {
        return "RemoteProvider{version='" + this.version + '\'' + ", clientTimeout=" + this.clientTimeout + ", serializeType='" + this.serializeType + '\'' + ", corePoolSize=" + this.corePoolSize + ", maxPoolSize=" + this.maxPoolSize + ", interface='" + this.intface + '\'' + ", group='" + this.group + '\'' + '}';
    }
}

