/*
 * Decompiled with CFR 0.152.
 */
package com.haotian.remote;

import com.haotian.remote.ProxyConsumer;
import com.haotian.remote.RemoteHandler;
import com.haotian.remote.RemoteInvokeHandler;
import com.haotian.remote.RemoteProviderFactoryBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class RemoteInvokeBeanWrapper
implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?>[] classes;
        Class<?> beanClass = bean.getClass();
        Method[] methods = beanClass.getMethods();
        boolean findRemoteInvoke = false;
        for (Method method : methods) {
            if (method.getAnnotation(RemoteHandler.class) == null) continue;
            findRemoteInvoke = true;
            break;
        }
        System.out.println("beanclass->" + beanClass + "------------->" + findRemoteInvoke);
        if (!findRemoteInvoke) {
            return bean;
        }
        ArrayList supperIntfaces = new ArrayList();
        for (Class<?> clazz : classes = beanClass.getInterfaces()) {
            if (clazz.getAnnotation(ProxyConsumer.class) == null) continue;
            supperIntfaces.add(clazz);
        }
        classes = new Class[supperIntfaces.size()];
        supperIntfaces.toArray(classes);
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), classes, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RemoteHandler remoteHandler = method.getAnnotation(RemoteHandler.class);
                if (remoteHandler == null) {
                    return method.invoke(proxy, args);
                }
                RemoteInvokeHandler invocationHandler = RemoteProviderFactoryBean.getRemoteInvokeHandler(remoteHandler.value());
                return invocationHandler.invoke(proxy, method, args);
            }
        });
    }
}

