package com.haotian.remote;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class RemoteInvokeBeanWrapper implements BeanPostProcessor {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClass = bean.getClass();
        for (int i = 0; i < 10 && Proxy.isProxyClass(beanClass); i++) {
            if (RemoteInvokeHandler.class.isInstance(Proxy.getInvocationHandler(bean))) {
                break;
            }
            Method getTargetClassMethod = null;
            try {
                getTargetClassMethod = beanClass.getMethod("getTargetClass");
                beanClass = (Class<?>) getTargetClassMethod.invoke(bean);
            } catch(NoSuchMethodException e) {
                logger.warning(e.getMessage());
            } catch (Throwable e) {
                throw new RuntimeException("unwrap proxy class error", e);
            }

        }
        Method[] methods = beanClass.getMethods();
        boolean findRemoteInvoke = false;
        for (Method method: methods) {
            System.out.println("+++++++++++>" + method.getName());
            if (method.getAnnotation(RemoteHandler.class) == null) {
                continue;
            }
            findRemoteInvoke = true;
            break;
        }
        System.out.println(beanName + "|||beanclass->" + beanClass + "------------->" + findRemoteInvoke);
        if (!findRemoteInvoke) {
            return bean;
        }

        List<Class<?>> supperIntfaces = new ArrayList<Class<?>>();
        Class<?>[] classes = beanClass.getInterfaces();
        for(Class<?> clazz: classes) {
            if (clazz.getAnnotation(ProxyConsumer.class) != null) {
                supperIntfaces.add(clazz);
            }
        }
        classes = new Class<?>[supperIntfaces.size()];
        supperIntfaces.toArray(classes);
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), classes, new InvocationHandler() {
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RemoteHandler remoteHandler = method.getAnnotation(RemoteHandler.class);
                if (remoteHandler == null) {
                    return method.invoke(proxy, args);
                }
                InvocationHandler invocationHandler = RemoteProviderFactoryBean.getRemoteInvokeHandler(remoteHandler.value());
                return invocationHandler.invoke(proxy, method, args);
            }
        });
    }
}
