/*
 * Decompiled with CFR 0.152.
 */
package com.haotian.remote;

import com.haotian.remote.ProxyConsumer;
import com.haotian.remote.RemoteHandler;
import com.haotian.remote.RemoteInvokeHandler;
import com.haotian.remote.RemoteProviderFactoryBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class RemoteInvokeBeanWrapper
implements BeanPostProcessor {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, String beanName) throws BeansException {
        Class<?>[] classes;
        Class beanClass = bean.getClass();
        for (int i = 0; i < 10 && Proxy.isProxyClass(beanClass) && !RemoteInvokeHandler.class.isInstance(Proxy.getInvocationHandler(bean)); ++i) {
            Method getTargetClassMethod = null;
            try {
                getTargetClassMethod = beanClass.getMethod("getTargetClass", new Class[0]);
                beanClass = (Class)getTargetClassMethod.invoke(bean, new Object[0]);
                continue;
            }
            catch (NoSuchMethodException e) {
                this.logger.warning(e.getMessage());
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("unwrap proxy class error", e);
            }
        }
        Method[] methods = beanClass.getMethods();
        boolean findRemoteInvoke = false;
        for (Method method : methods) {
            System.out.println("+++++++++++>" + method.getName());
            if (method.getAnnotation(RemoteHandler.class) == null) continue;
            findRemoteInvoke = true;
            break;
        }
        System.out.println(beanName + "|||beanclass->" + beanClass + "------------->" + findRemoteInvoke);
        if (!findRemoteInvoke) {
            return bean;
        }
        ArrayList supperIntfaces = new ArrayList();
        for (Class<?> clazz : classes = beanClass.getInterfaces()) {
            if (clazz.getAnnotation(ProxyConsumer.class) == null) continue;
            supperIntfaces.add(clazz);
        }
        classes = new Class[supperIntfaces.size()];
        supperIntfaces.toArray(classes);
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), classes, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RemoteHandler remoteHandler = method.getAnnotation(RemoteHandler.class);
                Object targetSource = proxy;
                for (int i = 0; i < 10 && Proxy.isProxyClass(targetSource.getClass()) && !RemoteInvokeHandler.class.isInstance(Proxy.getInvocationHandler(bean)); ++i) {
                    Method getTargetSourceMethod = null;
                    try {
                        getTargetSourceMethod = targetSource.getClass().getMethod("getTargetSource", new Class[0]);
                        targetSource = getTargetSourceMethod.invoke(bean, new Object[0]);
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        RemoteInvokeBeanWrapper.this.logger.warning(e.getMessage());
                        continue;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("unwrap proxy source error", e);
                    }
                }
                if (remoteHandler == null) {
                    return method.invoke(targetSource, args);
                }
                RemoteInvokeHandler invocationHandler = RemoteProviderFactoryBean.getRemoteInvokeHandler(remoteHandler.value());
                return invocationHandler.invoke(proxy, method, args);
            }
        });
    }
}

