/*
 * Decompiled with CFR 0.152.
 */
package com.haotian.remote;

import com.haotian.remote.ProxyConsumer;
import com.haotian.remote.ProxyProvider;
import com.haotian.remote.RemoteHandler;
import com.haotian.remote.RemoteMethodInvokeHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class RemoteInvokeBeanWrapper
implements BeanPostProcessor {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class beanClass = bean.getClass();
        Class<?>[] beanInterfaces = beanClass.getInterfaces();
        if (beanInterfaces == null || beanInterfaces.length == 0) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("beanName[" + beanName + "] has none interface; return source bean");
            }
            return bean;
        }
        ArrayList beanInterfaceList = new ArrayList();
        for (Class<?> beanInterface : beanInterfaces) {
            if (beanInterface.getAnnotation(ProxyConsumer.class) == null) continue;
            beanInterfaceList.add(beanInterface);
        }
        if (beanInterfaceList.isEmpty()) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("beanName[" + beanName + "] is not ProxyConsumer implement bean; return source bean");
            }
            return bean;
        }
        Object beanSource = bean;
        boolean findSource = false;
        for (int i = 0; i < 10 && Proxy.isProxyClass(beanClass); ++i) {
            if (Proxy.getInvocationHandler(beanSource) instanceof RemoteMethodInvokeHandler) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.info("beanName[" + beanName + "] has wrappered; return source bean");
                }
                return beanSource;
            }
            Object methodGetTargetClass = null;
            Method methodGetTargetSource = null;
            try {
                methodGetTargetClass = beanClass.getMethod("getTargetClass", new Class[0]);
                methodGetTargetSource = beanClass.getMethod("getTargetSource", new Class[0]);
                beanClass = (Class)((Method)methodGetTargetClass).invoke(beanSource, new Object[0]);
                beanSource = methodGetTargetSource.invoke(beanSource, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                this.logger.warning(e.getMessage());
            }
            catch (Throwable e) {
                throw new RuntimeException("unwrap proxy class error", e);
            }
            if (beanClass.getAnnotation(ProxyProvider.class) == null) continue;
            findSource = true;
            break;
        }
        if (!findSource) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("beanName[" + beanName + "] is not signed ProxyProvider; return source bean");
            }
            return bean;
        }
        findSource = false;
        Method[] methods = beanClass.getMethods();
        for (Method method : methods) {
            if (method.getAnnotation(RemoteHandler.class) == null) continue;
            findSource = true;
            break;
        }
        if (!findSource) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("beanName[" + beanName + "] has not RemoteHandler method; return source bean");
            }
            return bean;
        }
        Class[] supperInterfaces = new Class[beanInterfaceList.size()];
        beanInterfaceList.toArray(supperInterfaces);
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("wrap bean[" + beanName + "]");
        }
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), supperInterfaces, (InvocationHandler)new RemoteMethodInvokeHandler());
    }
}

