/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.business.userhelp.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.business.userhelp.conf.BodyReaderHttpServletRequestWrapper;
import com.ohaotian.business.userhelp.conf.ParameterRequestWrapper;
import com.ohaotian.business.userhelp.helper.RSAUtils;
import com.ohaotian.business.userhelp.helper.UserHelper;
import com.ohaotian.plugin.cache.CacheClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

@WebFilter(urlPatterns={"/*"})
@Component
@Order(value=0x7FFFFFFF)
public class UserInfoProcessFilter
implements Filter {
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${token.exclude:/login;/logout;}")
    private String tokenExclude;
    @Value(value="${token.expireTime:3600}")
    private Integer expireTime;
    @Value(value="${filter.close:false}")
    private boolean closeFilter;
    private List<String> excludedUris = new ArrayList<String>();
    private UserHelper userHelper;
    private static final Logger log = LoggerFactory.getLogger(UserInfoProcessFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext attribute = (WebApplicationContext)filterConfig.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        this.userHelper = (UserHelper)attribute.getBean(UserHelper.class);
        if (this.tokenExclude != null) {
            String[] excludeUri = this.tokenExclude.split(";");
            for (int i = 0; i != excludeUri.length; ++i) {
                this.excludedUris.add(excludeUri[i]);
            }
        }
        log.info("--------------UserInfoProcessFilter----------->>>>>init>>>>>>----------------------");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse rep = (HttpServletResponse)response;
        if (this.isContains(req.getRequestURI())) {
            chain.doFilter((ServletRequest)req, (ServletResponse)rep);
            return;
        }
        if (this.closeFilter) {
            String userId = req.getHeader("userId");
            log.info("\u5f53\u524d\u767b\u5f55\u4eba:" + userId);
            if (!StringUtils.isEmpty((Object)userId) && Pattern.matches("^\\d{1,20}$", userId)) {
                this.userHelper.setThreadUser(Long.parseLong(userId));
            } else {
                this.userHelper.setThreadUser(null);
            }
            chain.doFilter(request, response);
            return;
        }
        if (this.canAccess(req)) {
            if ("POST".equals(req.getMethod().toUpperCase())) {
                Map properties = req.getParameterMap();
                if (!properties.isEmpty()) {
                    ParameterRequestWrapper requestWrapper = new ParameterRequestWrapper((HttpServletRequest)request);
                    Map<String, Object> rMap = this.userHelper.getUserInfoMaps();
                    requestWrapper.addAllParameters(rMap);
                    chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)rep);
                    return;
                }
                if (req.getContentType().contains("application/json")) {
                    String inputStr;
                    BufferedReader streamReader = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream(), "UTF-8"));
                    StringBuilder responseStrBuilder = new StringBuilder();
                    while ((inputStr = streamReader.readLine()) != null) {
                        responseStrBuilder.append(inputStr);
                    }
                    if (responseStrBuilder != null && responseStrBuilder.length() > 0) {
                        JSONObject jsonObject = JSONObject.parseObject((String)responseStrBuilder.toString());
                        Map<String, Object> rMap = this.userHelper.getUserInfoMaps();
                        log.info("uMap---->{}", (Object)rMap.toString());
                        if (rMap != null) {
                            jsonObject.put("userId", rMap.get("userId"));
                            jsonObject.put("name", rMap.get("name"));
                            jsonObject.put("username", rMap.get("username"));
                            jsonObject.put("orgId", rMap.get("orgId"));
                            jsonObject.put("tenantId", rMap.get("tenantId"));
                            log.info("---->{}", (Object)jsonObject.toJSONString());
                            try {
                                chain.doFilter((ServletRequest)new BodyReaderHttpServletRequestWrapper(req, jsonObject.toJSONString()), (ServletResponse)rep);
                                return;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                log.error("\u5305\u88c5\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0:{}", (Object)e.getMessage());
                            }
                        }
                    }
                }
            }
            chain.doFilter((ServletRequest)req, (ServletResponse)rep);
        } else {
            HashMap<String, String> rMap = new HashMap<String, String>();
            rMap.put("code", "401");
            rMap.put("message", "\u7528\u6237\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u9646!");
            rep.setContentType("application/json");
            rep.setCharacterEncoding("utf-8");
            PrintWriter printWriter = rep.getWriter();
            printWriter.write(JSON.toJSONString(rMap));
            printWriter.flush();
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnMsg(Object msg, HttpServletResponse response) {
        try (PrintWriter writer = null;){
            response.setContentType("text/plain;charset=UTF-8");
            writer = response.getWriter();
            writer.write(this.objToJsonString(msg));
            writer.flush();
        }
    }

    private String objToJsonString(Object msg) {
        return JSON.toJSONString((Object)msg, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullBooleanAsFalse});
    }

    public UserHelper getUserHelper() {
        return this.userHelper;
    }

    public void setUserHelper(UserHelper userHelper) {
        this.userHelper = userHelper;
    }

    private boolean isContains(String uri) {
        if (uri.contains(".")) {
            return true;
        }
        for (String excludedUri : this.excludedUris) {
            if (!uri.contains(excludedUri)) continue;
            return true;
        }
        return false;
    }

    private boolean canAccess(HttpServletRequest req) {
        try {
            String token = req.getHeader("Authorization");
            String userId = req.getHeader("userId");
            log.info("token is {}", (Object)token);
            if (token != null && !"".equals(token) && !"null".equals(token) || !"".equals(userId) && userId != null) {
                String rv;
                JSONObject rmap;
                String cacheToken;
                if ("".equals(userId) || userId == null) {
                    String realToken = RSAUtils.defaultDecrypt(token);
                    String[] t = realToken.split("\\|");
                    userId = t[0];
                }
                log.info("userId is {}", (Object)userId);
                if (this.cacheClient.get(userId) != null && token.equals(cacheToken = (rmap = JSON.parseObject((String)(rv = this.cacheClient.get(userId).toString()))).get("token").toString())) {
                    this.cacheClient.expire(userId.getBytes(), this.expireTime.intValue());
                    log.info("\u5f53\u524d\u767b\u5f55\u4eba:" + userId);
                    if (!StringUtils.isEmpty((Object)userId) && Pattern.matches("^\\d{1,20}$", userId)) {
                        this.userHelper.setThreadUser(Long.parseLong(userId));
                    } else {
                        log.info("test--------------");
                        this.userHelper.setThreadUser(null);
                    }
                    Map sPo = (Map)rmap.get("uInfo");
                    if (sPo != null) {
                        this.userHelper.setThreadUserInfo(sPo);
                    }
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8bf7\u6c42token\u6821\u9a8c\u5931\u8d25,\u8bf7\u6c42url\u4e3a:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)req.getRequestURL(), (Object)e.getMessage());
        }
        return false;
    }

    private Map<String, String> getParameterMap(HttpServletRequest request) {
        Map properties = request.getParameterMap();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Iterator iter = properties.entrySet().iterator();
        String name = "";
        String value = "";
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            name = (String)entry.getKey();
            Object valueObj = entry.getValue();
            if (null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[])valueObj;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString();
            }
            returnMap.put(name, value);
        }
        return returnMap;
    }
}

