/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.business.userhelp.helper;

import com.ohaotian.business.userhelp.entity.UserInfo;
import com.ohaotian.business.userhelp.service.CustomUserDetailsService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserHelper {
    private static final Logger logger = LoggerFactory.getLogger(UserHelper.class);
    @Autowired
    private CustomUserDetailsService customUserDetailsService;
    private static final ThreadLocal<Long> CURRENT_USER = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> CURRENT_USER_INFO = new ThreadLocal();

    public Long getUserId() {
        Long userId = CURRENT_USER.get();
        logger.info("\u5f53\u524d\u767b\u5f55\u4eba\uff1a" + userId);
        return userId;
    }

    public UserInfo getUserInfo() {
        Long userId = CURRENT_USER.get();
        logger.info("\u5f53\u524d\u767b\u5f55\u4eba\uff1a" + userId);
        if (userId == null) {
            return new UserInfo();
        }
        UserInfo userInfo = this.customUserDetailsService.getUserInfo(userId);
        return userInfo;
    }

    public UserInfo getFullUserInfo() {
        Long userId = CURRENT_USER.get();
        logger.info("\u5f53\u524d\u767b\u5f55\u4eba\uff1a" + userId);
        if (userId == null) {
            return new UserInfo();
        }
        UserInfo userInfo = this.customUserDetailsService.getFullUserInfo(userId);
        return userInfo;
    }

    public UserInfo getUserAuthority() {
        Long userId = CURRENT_USER.get();
        logger.info("\u5f53\u524d\u767b\u5f55\u4eba\uff1a" + userId);
        if (userId == null) {
            return new UserInfo();
        }
        UserInfo userInfo = this.customUserDetailsService.loadAuthority(userId);
        return userInfo;
    }

    public void setThreadUser(Long userId) {
        CURRENT_USER.set(userId);
    }

    public void setThreadUserInfo(Map<String, Object> uMap) {
        CURRENT_USER_INFO.set(uMap);
    }

    public Map<String, Object> getUserInfoMaps() {
        return CURRENT_USER_INFO.get();
    }
}

