/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.business.userhelp.service.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.business.authority.api.application.service.SelectApplicationByUserBusiService;
import com.ohaotian.business.authority.api.application.service.SelectByApplicationCodeBusiService;
import com.ohaotian.business.authority.api.menu.bo.AccessMenu;
import com.ohaotian.business.authority.api.menu.bo.SelectAccessMenuReqBO;
import com.ohaotian.business.authority.api.menu.bo.SelectAccessMenuRspBO;
import com.ohaotian.business.authority.api.menu.bo.SelectAuthoritysMenuReqBO;
import com.ohaotian.business.authority.api.menu.bo.SelectAuthoritysMenuRspBO;
import com.ohaotian.business.authority.api.menu.service.SelectAccessMenuService;
import com.ohaotian.business.authority.api.menu.service.SelectAuthoritysMenuService;
import com.ohaotian.business.authority.api.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.business.authority.api.organisation.bo.RspOrganisationBO;
import com.ohaotian.business.authority.api.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.business.authority.api.role.bo.SelectRoleAuthoritysReqBO;
import com.ohaotian.business.authority.api.role.bo.SelectRoleAuthoritysRspBO;
import com.ohaotian.business.authority.api.role.service.SelectRoleAuthoritysService;
import com.ohaotian.business.authority.api.station.bo.StationBO;
import com.ohaotian.business.authority.api.tenant.bo.TenantIdBO;
import com.ohaotian.business.authority.api.tenant.bo.TenantRspBO;
import com.ohaotian.business.authority.api.tenant.service.SelectTenantByIdService;
import com.ohaotian.business.authority.api.user.bo.SelectUserInfoReqBO;
import com.ohaotian.business.authority.api.user.bo.SelectUserInfoRspBO;
import com.ohaotian.business.authority.api.user.bo.SelectUserStaionRspBO;
import com.ohaotian.business.authority.api.user.bo.UserIdBO;
import com.ohaotian.business.authority.api.user.service.SelectUserInfoService;
import com.ohaotian.business.authority.api.user.service.SelectUserStaionByUserIdService;
import com.ohaotian.business.userhelp.condition.YqConditionalOnProperty;
import com.ohaotian.business.userhelp.entity.AuthorityInfo;
import com.ohaotian.business.userhelp.entity.MenuInfo;
import com.ohaotian.business.userhelp.entity.UserInfo;
import com.ohaotian.business.userhelp.service.CustomUserDetailsService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@YqConditionalOnProperty(name={"rpc.type"}, havingValue="HSF")
public class HsfCustomUserDetailsServiceImpl
implements CustomUserDetailsService {
    private final Logger logger = LoggerFactory.getLogger(HsfCustomUserDetailsServiceImpl.class);
    @Value(value="${app.code}")
    private String appCode;
    @HSFConsumer(serviceGroup="authority-new", serviceVersion="2.0.0")
    private SelectUserInfoService selectUserInfoService;
    @HSFConsumer(serviceGroup="authority-new", serviceVersion="2.0.0")
    private SelectAccessMenuService selectAccessMenuService;
    @HSFConsumer(serviceGroup="authority-new", serviceVersion="2.0.0")
    private SelectAuthoritysMenuService selectAuthoritysMenuService;
    @HSFConsumer(serviceGroup="authority-new", serviceVersion="2.0.0")
    private SelectRoleAuthoritysService selectRoleAuthoritysService;
    @HSFConsumer(serviceGroup="authority-new", serviceVersion="2.0.0")
    private SelectOrganisationByOrgIdService selectOrganisationByOrgIdService;
    @HSFConsumer(serviceGroup="authority-new", serviceVersion="2.0.0")
    private SelectApplicationByUserBusiService selectApplicationByUserBusiService;
    @HSFConsumer(serviceGroup="authority-new", serviceVersion="2.0.0")
    private SelectTenantByIdService selectTenantByIdService;
    @HSFConsumer(serviceGroup="authority-new", serviceVersion="2.0.0")
    private SelectByApplicationCodeBusiService selectByApplicationCodeBusiService;
    @HSFConsumer(serviceGroup="authority-new", serviceVersion="2.0.0")
    private SelectUserStaionByUserIdService selectUserStaionByUserIdService;

    @Override
    public UserInfo getUserInfo(Long userId) {
        try {
            UserInfo userInfo = this.loadUserInfo(userId);
            UserIdBO userIdBO = new UserIdBO();
            userIdBO.setUserId(userInfo.getUserId());
            SelectUserStaionRspBO selectUserStaionRspBO = this.selectUserStaionByUserIdService.selectUserStation(userIdBO);
            if (selectUserStaionRspBO != null) {
                List stationsList = selectUserStaionRspBO.getStationsList();
                LinkedList<String> stationCodes = new LinkedList<String>();
                if (stationsList != null && stationsList.size() > 0) {
                    for (StationBO stationBO : stationsList) {
                        stationCodes.add(stationBO.getStationCode());
                    }
                }
                userInfo.setSelfStationCodes(stationCodes);
            }
            return userInfo;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public UserInfo getFullUserInfo(Long userId) throws ZTBusinessException {
        try {
            UserInfo userInfo = this.loadUserInfo(userId);
            if (userInfo == null) {
                UserInfo finalUserInfo = new UserInfo();
                finalUserInfo.setUserId(userId);
                return finalUserInfo;
            }
            long startTime = System.currentTimeMillis();
            ExecutorService exec = Executors.newCachedThreadPool();
            CountDownLatch countDownLatch = new CountDownLatch(2);
            exec.execute(() -> {
                try {
                    this.loadUserMenus(userInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    countDownLatch.countDown();
                }
            });
            exec.execute(() -> {
                this.loadUserAuthoritys(userInfo);
                countDownLatch.countDown();
            });
            countDownLatch.await();
            exec.shutdown();
            long endTime = System.currentTimeMillis();
            System.out.println("\u83b7\u53d6\u6743\u9650\u8fd0\u884c\u65f6\u95f4\uff1a " + (endTime - startTime) + "ms");
            return userInfo;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public UserInfo loadAuthority(Long userId) {
        UserInfo userInfo = this.loadUserInfo(userId);
        this.loadUserAuthoritys(userInfo);
        return userInfo;
    }

    private UserInfo loadUserInfo(Long userId) {
        UserInfo userInfo = new UserInfo();
        SelectUserInfoReqBO userInfoReqBO = new SelectUserInfoReqBO();
        userInfoReqBO.setUserId(userId);
        SelectUserInfoRspBO rspUser = this.selectUserInfoService.selectUserInfo(userInfoReqBO);
        if (rspUser != null) {
            userInfo.setUserId(rspUser.getUserId());
            userInfo.setName(rspUser.getName());
            userInfo.setUsername(rspUser.getLoginName());
            userInfo.setOrgId(rspUser.getOrgId());
            userInfo.setCellphone(rspUser.getCellPhone());
            if (rspUser.getTenantId() != null) {
                TenantIdBO tenantIdBO = new TenantIdBO();
                tenantIdBO.setTenantId(rspUser.getTenantId());
                TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
                userInfo.setTenantId(tenantRspBO.getTenantId());
                userInfo.setTenantName(tenantRspBO.getTenantName());
            }
            if (userInfo.getOrgId() != null) {
                OrganisationIdReqBO organisationIdReqBO = new OrganisationIdReqBO();
                organisationIdReqBO.setOrganisationId(userInfo.getOrgId());
                RspOrganisationBO organisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationIdReqBO);
                if (organisationBO != null) {
                    userInfo.setOrgPath(organisationBO.getOrgTreePath());
                    userInfo.setOrgName(organisationBO.getTitle());
                    userInfo.setInstitutionalCode(organisationBO.getAutoCode());
                }
            }
        } else {
            return null;
        }
        return userInfo;
    }

    private void loadUserMenus(UserInfo userInfo) throws Exception {
        SelectAccessMenuReqBO menuReqBO = new SelectAccessMenuReqBO();
        menuReqBO.setUserId(userInfo.getUserId());
        menuReqBO.setOrgTreePath(userInfo.getOrgPath());
        menuReqBO.setApplicationCode(this.appCode);
        SelectAccessMenuRspBO menuRspBO = this.selectAccessMenuService.selectAccessMenuService(menuReqBO);
        LinkedList<MenuInfo> unMenuInfos = new LinkedList<MenuInfo>();
        List menuList = menuRspBO.getAccessMenuList();
        if (menuList != null && menuList.size() > 0) {
            for (AccessMenu menu : menuList) {
                if (StringUtils.isNotBlank((CharSequence)menu.getMenuDomain())) {
                    menu.setDomain(menu.getMenuDomain());
                }
                MenuInfo menuInfo = new MenuInfo();
                BeanUtils.copyProperties((Object)menu, (Object)menuInfo);
                unMenuInfos.add(menuInfo);
            }
            userInfo.setUnstructuredMunes(unMenuInfos);
            HashMap<String, List<MenuInfo>> menuMap = new HashMap<String, List<MenuInfo>>();
            Map<String, List<AccessMenu>> menuListMap = this.groupBillingDataByAppCode(menuList);
            menuListMap.keySet().forEach(key -> {
                List accessMenus = (List)menuListMap.get(key);
                LinkedList<MenuInfo> menuInfos = new LinkedList<MenuInfo>();
                accessMenus.forEach(e -> {
                    MenuInfo menuInfo = new MenuInfo();
                    BeanUtils.copyProperties((Object)e, (Object)menuInfo);
                    if (StringUtils.isNotBlank((CharSequence)e.getMenuDomain())) {
                        menuInfo.setDomain(e.getMenuDomain());
                    }
                    menuInfos.add(menuInfo);
                });
                if (menuInfos.size() > 0) {
                    List<MenuInfo> buildByRecursive = this.buildByRecursive(menuInfos);
                    menuMap.put((String)key, buildByRecursive);
                }
            });
            userInfo.setMenus(menuMap);
        }
    }

    private void loadUserAuthoritys(UserInfo userInfo) {
        HashSet<AuthorityInfo> authorities = new HashSet<AuthorityInfo>();
        SelectAuthoritysMenuReqBO menuReqBO = new SelectAuthoritysMenuReqBO();
        menuReqBO.setUserId(userInfo.getUserId());
        menuReqBO.setApplicationCode(this.appCode);
        menuReqBO.setOrgTreePath(userInfo.getOrgPath());
        SelectAuthoritysMenuRspBO authoritysMenuRspBO = this.selectAuthoritysMenuService.selectAuthoritysMenuService(menuReqBO);
        List authorityMenuList = authoritysMenuRspBO.getAuthorityMenuList();
        if (authorityMenuList != null && authorityMenuList.size() > 0) {
            authorityMenuList.forEach(e -> {
                AuthorityInfo authorityInfo = new AuthorityInfo();
                BeanUtils.copyProperties((Object)e, (Object)authorityInfo);
                authorities.add(authorityInfo);
            });
        }
        SelectRoleAuthoritysReqBO roleAuthoritysReqBO = new SelectRoleAuthoritysReqBO();
        roleAuthoritysReqBO.setUserId(userInfo.getUserId());
        roleAuthoritysReqBO.setOrgTreePath(userInfo.getOrgPath());
        SelectRoleAuthoritysRspBO roleAuthoritysRspBO = this.selectRoleAuthoritysService.selectRoleAuthoritysService(roleAuthoritysReqBO);
        List roleAuthoritysRspBOAuthorityMenuList = roleAuthoritysRspBO.getAuthorityMenuList();
        if (roleAuthoritysRspBOAuthorityMenuList != null && roleAuthoritysRspBOAuthorityMenuList.size() > 0) {
            roleAuthoritysRspBOAuthorityMenuList.forEach(e -> {
                AuthorityInfo authorityInfo = new AuthorityInfo();
                BeanUtils.copyProperties((Object)e, (Object)authorityInfo);
                authorities.add(authorityInfo);
            });
        }
        userInfo.setPermission(authorities);
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(userInfo.getUserId());
        SelectUserStaionRspBO selectUserStaionRspBO = this.selectUserStaionByUserIdService.selectUserStation(userIdBO);
        if (selectUserStaionRspBO != null) {
            List stationsList = selectUserStaionRspBO.getStationsList();
            LinkedList<String> stationCodes = new LinkedList<String>();
            if (stationsList != null && stationsList.size() > 0) {
                for (StationBO stationBO : stationsList) {
                    stationCodes.add(stationBO.getStationCode());
                }
            }
            userInfo.setSelfStationCodes(stationCodes);
        }
    }

    private List<MenuInfo> buildByRecursive(List<MenuInfo> treeNodes) {
        Collections.sort(treeNodes);
        ArrayList<MenuInfo> trees = new ArrayList<MenuInfo>();
        for (MenuInfo treeNode : treeNodes) {
            if (treeNode.getParentId() != null) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        Collections.sort(trees);
        return trees;
    }

    private MenuInfo findChildren(MenuInfo root, List<MenuInfo> allMenus) {
        for (MenuInfo it : allMenus) {
            if (!root.getMenuId().equals(it.getParentId())) continue;
            if (root.getSubMenus() == null) {
                root.setSubMenus(new ArrayList<MenuInfo>());
            }
            root.getSubMenus().add(this.findChildren(it, allMenus));
        }
        return root;
    }

    private Map<String, List<AccessMenu>> groupBillingDataByAppCode(List<AccessMenu> billingList) throws Exception {
        HashMap<String, List<AccessMenu>> resultMap = new HashMap<String, List<AccessMenu>>();
        try {
            for (AccessMenu accessMenu : billingList) {
                if (resultMap.containsKey(accessMenu.getAppCode())) {
                    ((List)resultMap.get(accessMenu.getAppCode())).add(accessMenu);
                    continue;
                }
                ArrayList<AccessMenu> tmpList = new ArrayList<AccessMenu>();
                tmpList.add(accessMenu);
                resultMap.put(accessMenu.getAppCode(), tmpList);
            }
        }
        catch (Exception e) {
            throw new Exception("\u6309\u7167\u5b50\u7cfb\u7edf\u7f16\u7801\u5bf9\u83dc\u5355\u6570\u636e\u8fdb\u884c\u5206\u7ec4\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
        return resultMap;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }
}

