/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.business.userhelp.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.business.userhelp.condition.YqConditionalOnProperty;
import com.ohaotian.business.userhelp.entity.UserInfo;
import com.ohaotian.business.userhelp.service.CustomUserDetailsService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@YqConditionalOnProperty(name={"rpc.type"}, havingValue="Http")
public class HttpCustomUserDetailsServiceImpl
implements CustomUserDetailsService {
    private final Logger logger = LoggerFactory.getLogger(HttpCustomUserDetailsServiceImpl.class);
    @Value(value="${app.code}")
    private String appCode;
    @Value(value="${authority.domain:''}")
    private String authorityDomain;

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    @Override
    public UserInfo getUserInfo(Long userId) {
        JSONObject jsonObject;
        UserInfo userInfo = new UserInfo();
        String postUrl = this.authorityDomain.endsWith("/") ? this.authorityDomain : this.authorityDomain.concat("/");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("appCode", this.appCode);
        HttpResponse response = ((HttpRequest)HttpRequest.post((String)(postUrl + "userHelper/getUserInfo")).header("userId", userId.toString())).form(paramMap).execute();
        if (response.getStatus() == 200 && !StringUtils.isEmpty((Object)response.body()) && "0".equals((jsonObject = JSONObject.parseObject((String)response.body())).getString("code"))) {
            userInfo = (UserInfo)jsonObject.getObject("data", UserInfo.class);
            return userInfo;
        }
        userInfo.setUserId(userId);
        return userInfo;
    }

    @Override
    public UserInfo getFullUserInfo(Long userId) {
        JSONObject jsonObject;
        UserInfo userInfo = new UserInfo();
        String postUrl = this.authorityDomain.endsWith("/") ? this.authorityDomain : this.authorityDomain.concat("/");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("appCode", this.appCode);
        HttpResponse response = ((HttpRequest)HttpRequest.post((String)(postUrl + "userHelper/getFullUserInfo")).header("userId", userId.toString())).form(paramMap).execute();
        if (response.getStatus() == 200 && !StringUtils.isEmpty((Object)response.body()) && "0".equals((jsonObject = JSONObject.parseObject((String)response.body())).getString("code"))) {
            userInfo = (UserInfo)jsonObject.getObject("data", UserInfo.class);
            return userInfo;
        }
        userInfo.setUserId(userId);
        return userInfo;
    }

    @Override
    public UserInfo loadAuthority(Long userId) {
        JSONObject jsonObject;
        UserInfo userInfo = new UserInfo();
        String postUrl = this.authorityDomain.endsWith("/") ? this.authorityDomain : this.authorityDomain.concat("/");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("appCode", this.appCode);
        HttpResponse response = ((HttpRequest)HttpRequest.post((String)(postUrl + "userHelper/getUserAuthority")).header("userId", userId.toString())).form(paramMap).execute();
        if (response.getStatus() == 200 && !StringUtils.isEmpty((Object)response.body()) && "0".equals((jsonObject = JSONObject.parseObject((String)response.body())).getString("code"))) {
            userInfo = (UserInfo)jsonObject.getObject("data", UserInfo.class);
            return userInfo;
        }
        userInfo.setUserId(userId);
        return userInfo;
    }
}

