/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.impl;

import com.cgd.workflow.bo.BpmStartReqBO;
import com.cgd.workflow.bo.BpmStartRspBO;
import com.cgd.workflow.busin.service.BpmStartBusinService;
import com.ohaotian.commodity.busi.CommodityTypeExamineService;
import com.ohaotian.commodity.busi.TestSkuWorkFlowService;
import com.ohaotian.commodity.busi.bo.CommodityTypeExamineReqBO;
import com.ohaotian.commodity.busi.bo.CommodityTypeExamineRspBO;
import com.ohaotian.commodity.busi.bo.TestSkuWorkFlowReqBO;
import com.ohaotian.commodity.busi.constant.Constant;
import com.ohaotian.commodity.busi.constant.SupplyConstant;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.SkuOnShelveLogMapper;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.commodity.dao.po.SkuOnShelveLog;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSkuWorkFlowServiceImpl
implements TestSkuWorkFlowService {
    private static final Logger logger = LoggerFactory.getLogger(TestSkuWorkFlowServiceImpl.class);
    private SkuMapper skuMapper;
    private BpmStartBusinService bpmStartBusinService;
    private SkuOnShelveLogMapper skuOnShelveLogMapper;
    private CommodityTypeExamineService commodityTypeExamineService;
    private Properties pop;

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setBpmStartBusinService(BpmStartBusinService bpmStartBusinService) {
        this.bpmStartBusinService = bpmStartBusinService;
    }

    public void setSkuOnShelveLogMapper(SkuOnShelveLogMapper skuOnShelveLogMapper) {
        this.skuOnShelveLogMapper = skuOnShelveLogMapper;
    }

    public void setCommodityTypeExamineService(CommodityTypeExamineService commodityTypeExamineService) {
        this.commodityTypeExamineService = commodityTypeExamineService;
    }

    public void setPop(Properties pop) {
        this.pop = pop;
    }

    public void test(TestSkuWorkFlowReqBO skuId) {
        try {
            Sku sku = this.skuMapper.selectByPrimaryKey(skuId.getSkuId());
            CommodityTypeExamineReqBO typeReqBO = new CommodityTypeExamineReqBO();
            typeReqBO.setCommodityTypeId(sku.getCommodityTypeId());
            typeReqBO.setCreateTime(sku.getCreateTime());
            CommodityTypeExamineRspBO typeBO = this.commodityTypeExamineService.selectByCommodityTypeIdAndTime(typeReqBO);
            logger.info("\u5355\u54c1\u542f\u52a8\u5de5\u4f5c\u6d41\u670d\u52a1\u67e5\u8be2\u5546\u54c1\u7c7b\u578b\u662f\u5426\u91cd\u70b9" + typeBO.toString());
            SkuOnShelveLog skuOnShelveLog = new SkuOnShelveLog();
            BpmStartReqBO bpmStartReqBO = new BpmStartReqBO();
            bpmStartReqBO.setBusinessId(String.valueOf(sku.getSkuId()));
            bpmStartReqBO.setBusinessType("14");
            if (typeBO.getImpFollow().toString().equals("0")) {
                skuOnShelveLog.setApproveType(SupplyConstant.APPROVE_ON_SHELF_TYPE);
            } else if (typeBO.getImpFollow().toString().equals("1")) {
                logger.info("\u5355\u54c1\u542f\u52a8\u5de5\u4f5c\u6d41\u670d\u52a1\u66f4\u65b0\u5546\u54c1\u72b6\u6001" + typeBO.toString());
                skuOnShelveLog.setApproveType(SupplyConstant.APPROVE_GROUP_AUDIT_TYPE);
            }
            if (this.pop.getProperty("skuCreateId") == null || this.pop.getProperty("skuCreateId").isEmpty()) {
                logger.error("\u5355\u54c1\u542f\u52a8\u5de5\u4f5c\u6d41\u670d\u52a1\u5165\u53c2\u83b7\u53d6\u7528\u6237id\u4e3a\u7a7a");
                throw new Exception("\u5355\u54c1\u542f\u52a8\u5de5\u4f5c\u6d41\u670d\u52a1\u5165\u53c2\u83b7\u53d6\u7528\u6237id\u4e3a\u7a7a");
            }
            Long userId = Long.valueOf(this.pop.getProperty("skuCreateId"));
            bpmStartReqBO.setBusinessTitle("\u521b\u5efa\u5546\u54c1\u5e76\u63d0\u4ea4\u5ba1\u6838");
            bpmStartReqBO.setDetailUrl("\u5546\u54c1\u63d0\u4ea4\u5ba1\u6838");
            bpmStartReqBO.setStartFlag("1");
            bpmStartReqBO.setUserId(userId);
            bpmStartReqBO.setApplyerId(userId);
            HashMap<String, Number> variables = new HashMap<String, Number>();
            variables.put("supplierId", sku.getSupplierId());
            variables.put("impFollow", typeBO.getImpFollow());
            bpmStartReqBO.setVariables(variables);
            BpmStartRspBO bpmStart = this.bpmStartBusinService.bpmStart(bpmStartReqBO);
            if ("0000".equals(bpmStart.getRespCode())) {
                if (typeBO.getImpFollow().toString().equals("1")) {
                    sku.setSkuStatus(9);
                    this.skuMapper.updateSkuStateByExtSkuId(sku);
                }
                ArrayList<SkuOnShelveLog> skuOnShelveLogs = new ArrayList<SkuOnShelveLog>();
                skuOnShelveLog.setProcInstlId(bpmStart.getProcInstId());
                skuOnShelveLog.setSkuId(sku.getSkuId());
                skuOnShelveLog.setSupplierId(sku.getSupplierId());
                skuOnShelveLog.setApproveStatus(SupplyConstant.APPROVE_STATUS_START);
                skuOnShelveLog.setApproveResult(SupplyConstant.APPROVE_SUB_TYPE);
                skuOnShelveLog.setCreateLoginId(sku.getCreateLoginId());
                skuOnShelveLog.setCreateTime(new Date());
                skuOnShelveLog.setIsDelete(Constant.IS_DELETE.byteValue());
                skuOnShelveLogs.add(skuOnShelveLog);
                logger.info("\u5355\u54c1\u542f\u52a8\u5de5\u4f5c\u6d41\u670d\u52a1\u65e5\u5fd7\u6dfb\u52a0" + skuOnShelveLog.toString());
                this.skuOnShelveLogMapper.batchSkuOnShelveLog(skuOnShelveLogs);
            }
        }
        catch (Exception e) {
            logger.error("\u5355\u54c1\u542f\u52a8\u5de5\u4f5c\u6d41\u670d\u52a1\u5165\u53c2\uff1a" + e);
        }
    }
}

