/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.common.annotation;

import com.ohaotian.filedownload.common.annotation.RetryProcess;
import java.util.concurrent.atomic.AtomicInteger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RetryProcessAspect {
    private static final Logger log = LoggerFactory.getLogger(RetryProcessAspect.class);
    private AtomicInteger atomicInteger = new AtomicInteger(0);

    @AfterThrowing(pointcut="@annotation(com.ohaotian.filedownload.common.annotation.RetryProcess)")
    public void tryAgain(JoinPoint point) {
        try {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            RetryProcess retryProcess = methodSignature.getMethod().getAnnotation(RetryProcess.class);
            if (this.atomicInteger.intValue() < retryProcess.value()) {
                int i = this.atomicInteger.incrementAndGet();
                Thread.sleep(retryProcess.sleep() * i);
                log.debug("\u5f00\u59cb\u91cd\u8bd5\u7b2c" + i + "\u6b21");
                MethodInvocationProceedingJoinPoint methodPoint = (MethodInvocationProceedingJoinPoint)point;
                methodPoint.proceed();
            }
        }
        catch (Throwable throwable) {
            this.tryAgain(point);
        }
    }
}

