/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelSequenceNumberUpdater {
    public static void updateSequenceNumbers(String directoryPath) throws IOException {
        File directory = new File(directoryPath);
        File[] files = directory.listFiles();
        ArrayList<File> excelFiles = new ArrayList<File>();
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".xlsx")) continue;
            excelFiles.add(file);
        }
        Collections.sort(excelFiles);
        int sequenceNumber = 1;
        for (File file : excelFiles) {
            FileInputStream inputStream = new FileInputStream(file);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)inputStream);
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                Sheet sheet = workbook.getSheetAt(i);
                int lastRowNum = sheet.getLastRowNum();
                for (int j = 0; j <= lastRowNum; ++j) {
                    Row row = sheet.getRow(j);
                    if (j == 0) continue;
                    Cell cell = row.getCell(0);
                    cell.setCellValue((double)sequenceNumber);
                    ++sequenceNumber;
                }
            }
            inputStream.close();
            FileOutputStream outputStream = new FileOutputStream(file);
            workbook.write((OutputStream)outputStream);
            outputStream.close();
            workbook.close();
        }
    }
}

