/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.common.utils;

import com.ohaotian.filedownload.common.annotation.RetryProcessAspect;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(RetryProcessAspect.class);

    public static void compress(String srcFilePath, String destFilePath) {
        File src = new File(srcFilePath);
        if (!src.exists()) {
            throw new RuntimeException(srcFilePath + "\u4e0d\u5b58\u5728");
        }
        File zipFile = new File(destFilePath);
        try (FileOutputStream fos = new FileOutputStream(zipFile);){
            ZipOutputStream zos = new ZipOutputStream(fos);
            String baseDir = "";
            ZipUtils.compressbyType(src, zos, baseDir);
            zos.close();
        }
        catch (Exception e) {
            log.error("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38->{}", (Throwable)e);
            e.printStackTrace();
        }
    }

    private static void compressbyType(File src, ZipOutputStream zos, String baseDir) {
        if (!src.exists()) {
            return;
        }
        log.info("compress dir->{}", (Object)(baseDir + src.getName()));
        if (src.isFile()) {
            ZipUtils.compressFile(src, zos, baseDir);
        } else if (src.isDirectory()) {
            ZipUtils.compressDir(src, zos, baseDir);
        }
    }

    private static void compressFile(File file, ZipOutputStream zos, String baseDir) {
        if (!file.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            int count;
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipEntry entry = new ZipEntry(baseDir + file.getName());
            zos.putNextEntry(entry);
            byte[] buf = new byte[1024];
            while ((count = bis.read(buf)) != -1) {
                zos.write(buf, 0, count);
            }
            bis.close();
        }
        catch (Exception e) {
            log.error("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38->{}", (Throwable)e);
        }
    }

    private static void compressDir(File dir, ZipOutputStream zos, String baseDir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files.length == 0) {
            try {
                zos.putNextEntry(new ZipEntry(baseDir + dir.getName() + File.separator));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (File file : files) {
            ZipUtils.compressbyType(file, zos, baseDir + dir.getName() + File.separator);
        }
    }

    public static void main(String[] args) {
        ZipUtils.compress("/Users/feifuzeng/Desktop", "/Users/feifuzeng/temp/test.zip");
    }
}

