/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.config.cas;

import com.ohaotian.authority.config.cas.LocalUserInfoFilter;
import com.ohaotian.authority.config.cas.SpringCasAutoConfig;
import java.util.EventListener;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.jasig.cas.client.authentication.AuthenticationFilter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="auth", name={"type"}, havingValue="cas")
@EnableConfigurationProperties(value={SpringCasAutoConfig.class})
public class CasConfig {
    @Resource
    SpringCasAutoConfig autoconfig;
    private static boolean casEnabled = true;

    @Bean
    public SpringCasAutoConfig getSpringCasAutoconfig() {
        return new SpringCasAutoConfig();
    }

    @Bean
    public ServletListenerRegistrationBean<SingleSignOutHttpSessionListener> singleSignOutHttpSessionListener() {
        ServletListenerRegistrationBean listener = new ServletListenerRegistrationBean();
        listener.setEnabled(casEnabled);
        listener.setListener((EventListener)new SingleSignOutHttpSessionListener());
        listener.setOrder(1);
        return listener;
    }

    @Bean
    public FilterRegistrationBean singleSignOutFilter() {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setFilter((Filter)new SingleSignOutFilter());
        filterRegistration.setEnabled(casEnabled);
        if (this.autoconfig.getSignOutFilters().size() > 0) {
            filterRegistration.setUrlPatterns(this.autoconfig.getSignOutFilters());
        } else {
            filterRegistration.addUrlPatterns(new String[]{"/*"});
        }
        filterRegistration.addInitParameter("casServerUrlPrefix", this.autoconfig.getCasServerUrlPrefix());
        filterRegistration.addInitParameter("serverName", this.autoconfig.getServerName());
        filterRegistration.setName("singleFilter");
        filterRegistration.setOrder(2);
        return filterRegistration;
    }

    @Bean
    public FilterRegistrationBean authenticationFilter() {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setFilter((Filter)new AuthenticationFilter());
        filterRegistration.setEnabled(casEnabled);
        if (this.autoconfig.getAuthFilters().size() > 0) {
            filterRegistration.setUrlPatterns(this.autoconfig.getAuthFilters());
        } else {
            filterRegistration.addUrlPatterns(new String[]{"/*"});
        }
        filterRegistration.addInitParameter("casServerLoginUrl", this.autoconfig.getCasServerLoginUrl());
        filterRegistration.addInitParameter("serverName", this.autoconfig.getServerName());
        filterRegistration.addInitParameter("useSession", this.autoconfig.isUseSession() ? "true" : "false");
        filterRegistration.addInitParameter("redirectAfterValidation", this.autoconfig.isRedirectAfterValidation() ? "true" : "false");
        filterRegistration.addInitParameter("ignorePattern", this.autoconfig.getIgnorePattern());
        filterRegistration.setOrder(3);
        return filterRegistration;
    }

    @Bean
    public FilterRegistrationBean cas20ProxyReceivingTicketValidationFilter() {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        Cas20ProxyReceivingTicketValidationFilter cas20ProxyReceivingTicketValidationFilter = new Cas20ProxyReceivingTicketValidationFilter();
        cas20ProxyReceivingTicketValidationFilter.setServerName(this.autoconfig.getServerName());
        filterRegistration.setFilter((Filter)cas20ProxyReceivingTicketValidationFilter);
        filterRegistration.setEnabled(casEnabled);
        if (this.autoconfig.getValidateFilters().size() > 0) {
            filterRegistration.setUrlPatterns(this.autoconfig.getValidateFilters());
        } else {
            filterRegistration.addUrlPatterns(new String[]{"/*"});
        }
        filterRegistration.addInitParameter("casServerUrlPrefix", this.autoconfig.getCasServerUrlPrefix());
        filterRegistration.addInitParameter("serverName", this.autoconfig.getServerName());
        filterRegistration.setOrder(4);
        return filterRegistration;
    }

    @Bean
    public FilterRegistrationBean localUserInfoFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new LocalUserInfoFilter());
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setName("localUserInfoFilter");
        registrationBean.setOrder(5);
        return registrationBean;
    }
}

