/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.config.jwt;

import com.ohaotian.authority.config.jwt.JwtFilter;
import com.ohaotian.authority.config.jwt.JwtProperties;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="auth", name={"type"}, havingValue="jwt")
@EnableConfigurationProperties(value={JwtProperties.class})
public class JwtConfig {
    private static final Logger logger = LogManager.getLogger(JwtConfig.class);
    @Resource
    JwtProperties jwtProperties;

    @Bean
    public FilterRegistrationBean jwtFilter() {
        FilterRegistrationBean filterBean = new FilterRegistrationBean();
        logger.info("\u52a0\u8f7djwtFilter Bean");
        filterBean.setFilter((Filter)new JwtFilter(this.jwtProperties));
        filterBean.setName("jwtFilter");
        filterBean.setOrder(-10);
        String[] patterns = this.jwtProperties.getUrlPatterns().split(";");
        filterBean.addUrlPatterns(patterns);
        return filterBean;
    }
}

